<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.Rss20");
Rhaco::import("network.http.Http");
Rhaco::import("io.FileUtil");

class Rss20Test extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new Rss20();
		$src = Http::body(Rhaco::url("feed.php?mode=rss20"));

		$feed->set($src);

		$this->_assert($feed);
	}
	function testGet(){
		$feed = new Rss20();
		$src = Http::body(Rhaco::url("feed.php?mode=rss20"));

		$feed->set($src);
		$fileUtil = new FileUtil();
//		$fileUtil->write(Rhaco::templatepath("tag/feed/rss20Result.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/rss20Result.xml")),$feed->get());
		
		$newfeed = new Rss20();
		$newfeed->set($feed->get());
		$this->_assert($newfeed);
	}
	function _assert($feed){
		$this->assertEquals("2.0",$feed->getVersion());		
		$this->assertTrue(Variable::isClassType(RssChannel20,$feed->getChannel()));
		
		$ch = $feed->getChannel();
		$this->assertEquals("データベース",$ch->getTitle());
		$this->assertEquals("データベースの更新情報",$ch->getDescription());
		$this->assertEquals("ja",$ch->getLanguage());
		$this->assertEquals("Copyright(C),2006 rhaco",$ch->getCopyright());
		
		$this->assertEquals(2,sizeof($feed->getItemList()));
		foreach($feed->getItemList() as $item){
			$this->assertTrue(Variable::isClassType(RssItem,$item));
			$this->assertTrue(strlen($item->getTitle()) > 0);
			$this->assertTrue(strlen($item->getDescription()) > 0);
			$this->assertTrue(strlen($item->getGuid())> 0);			

			$this->assertEquals("Fri, 18 Aug 2006 13:57:18 +0900",$item->getPubDate());			
		}
	}
}
?>