<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.TagUtil");
Rhaco::import("io.FileUtil");
Rhaco::importLibrary("ClassDummy");

class TagUtilTest extends UnitTest{
	var $tagUtil;
	var $fileUtil;
	
	function setUp(){
		$this->fileUtil = new FileUtil();
		$this->tagUtil = new TagUtil();		
		
		$tag = new Tag("root");

		$intag = new Tag("parent");
		$intag->addParameterValue("id",1);
		$intag->addParameterValue("abc","ABC");
		$intag->addTag(new Tag("data1","abc"));
		$intag->addTag(new Tag("data2","def"));
		$intag->addTag(new Tag("data3","ghi"));
		$tag->addValue($intag->get());

		$intag = new Tag("parent");
		$intag->addParameterValue("id",2);
		$intag->addParameterValue("abc","XYZ");		
		$intag->addTag(new Tag("data1","jkl"));
		$intag->addTag(new Tag("data2","mno"));
		$intag->addTag(new Tag("data3","pqr"));
		$tag->addValue($intag->get());
		
		$this->fileUtil->write(Rhaco::templatepath("tag/tagUtilData.xml"),$tag->get());
	}
    function tearDown(){
		$this->tagUtil->close(Rhaco::templatepath("tag/tagUtilData.xml"));
		$this->fileUtil->rm(Rhaco::templatepath("tag/tagUtilData.xml"));
	}
	function testSelect(){
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		$this->assertEquals(2,sizeof($list));
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("data1"));
		$this->assertEquals(2,sizeof($list));		

		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("data1","abc"));
		$this->assertEquals(1,sizeof($list));

		$tag = new Tag("parent");
		$tag->addParameterValue("id",2);
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		$this->assertEquals(1,sizeof($list));
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"),1,0);
		$this->assertEquals(1,sizeof($list));
		$this->assertEquals(1,$list[0]->getParameter("id"));
	}
	function testCount(){
		$this->assertEquals(2,$this->tagUtil->count(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent")));
		$this->assertEquals(1,$this->tagUtil->count(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("data1","abc")));
	}
	function testGet(){
		$tag = new Tag("parent");
		$tag->addParameterValue("id",2);
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		$this->assertEquals(2,$gettag->getParameter("id"));
		
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		$this->assertFalse($gettag);
	}

	function testInsert(){
		$tag = new Tag("parent");
		$tag->addParameterValue("id",3);
		$tag->addTag(new Tag("data1","123"));
		$tag->addTag(new Tag("data2","456"));
		$tag->addTag(new Tag("data3","789"));		
		$this->tagUtil->insert(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		$this->assertEquals(3,sizeof($list));
	}
	function testUpdate(){
		$contag = new Tag("parent");
		$contag->addParameterValue("id",2);
		
		$tag = new Tag("parent");
		$tag->addParameterValue("id",2);
		$tag->addTag(new Tag("data1","123"));
		$tag->addTag(new Tag("data2","456"));
		$tag->addTag(new Tag("data3","789"));		
		$this->tagUtil->update(Rhaco::templatepath("tag/tagUtilData.xml"),$tag,$contag);
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		$this->assertEquals(2,sizeof($list));		
		
		$tag = new Tag("parent");
		$tag->addParameterValue("id",2);
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);

		$data1 = $gettag->getIn("data1"); 
		$data2 = $gettag->getIn("data2");		
		$data3 = $gettag->getIn("data3");
		
		$this->assertEquals("123",$data1[0]->getValue());
		$this->assertEquals("456",$data2[0]->getValue());
		$this->assertEquals("789",$data3[0]->getValue());
	}
	function testDelete(){
		$contag = new Tag("parent");
		$contag->addParameterValue("id",2);
		$this->tagUtil->delete(Rhaco::templatepath("tag/tagUtilData.xml"),$contag);
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		$this->assertEquals(1,sizeof($list));		
	}
	function testTransaction(){
		$this->tagUtil->setTransaction(true);

		$contag = new Tag("parent");
		$contag->addParameterValue("id",2);
		$this->tagUtil->delete(Rhaco::templatepath("tag/tagUtilData.xml"),$contag);
		$this->tagUtil->rollback(Rhaco::templatepath("tag/tagUtilData.xml"));

		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		$this->assertEquals(2,sizeof($list));
		
		$contag = new Tag("parent");
		$contag->addParameterValue("id",2);
		$this->tagUtil->delete(Rhaco::templatepath("tag/tagUtilData.xml"),$contag);
		$this->tagUtil->commit(Rhaco::templatepath("tag/tagUtilData.xml"));
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		$this->assertEquals(1,sizeof($list));
	}
	
	function testGetIn(){
		$src = $this->fileUtil->read(Rhaco::templatepath("tag/tagUtilData.xml"));
		$tag = new Tag();
		$tag->set($src,"root");
		
		$list = $this->tagUtil->getIn($tag,new Tag("data1","abc"));
		$this->assertEquals(1,sizeof($list));		
		
		$list = $this->tagUtil->getIn($tag,new Tag("data1"));
		$this->assertEquals(2,sizeof($list));
	}
	function testGetNotIn(){
		$src = $this->fileUtil->read(Rhaco::templatepath("tag/tagUtilData.xml"));
		$tag = new Tag();
		$tag->set($src,"root");
		
		$list = $this->tagUtil->getNotIn($tag,new Tag("data1","abc"));
		$this->assertEquals(1,sizeof($list));		

		$list = $this->tagUtil->getNotIn($tag,new Tag("data1"));
		$this->assertEquals(0,sizeof($list));

		$list = $this->tagUtil->getNotIn($tag,new Tag("hoge"));
		$this->assertEquals(0,sizeof($list));

		$list = $this->tagUtil->getNotIn($tag,new Tag("data2","mno"));
		$this->assertEquals(1,sizeof($list));			
	}
	function testIsTagfile(){
		$this->assertTrue($this->tagUtil->isTagfile(Rhaco::templatepath("tag/tagUtilData.xml"),"root"));
		$this->assertFalse($this->tagUtil->isTagfile(Rhaco::templatepath("tag/tagUtilData.xml"),"boot"));
		$this->assertTrue($this->tagUtil->isTagfile(Rhaco::templatepath("tag/tagUtilIsTagFile.xml"),"root",true));	

		$this->tagUtil->close(Rhaco::templatepath("tag/tagUtilIsTagFile.xml"));		
		$this->fileUtil->rm(Rhaco::templatepath("tag/tagUtilIsTagFile.xml"));
	}
	function testSort(){
		$tag = new Tag("parent");
		$tag->addParameterValue("id",4);
		$tag->addTag(new Tag("data1","123"));
		$tag->addTag(new Tag("data2","456"));
		$tag->addTag(new Tag("data3","789"));		
		$this->tagUtil->insert(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		
		$tag = new Tag("parent");
		$tag->addParameterValue("id",3);
		$tag->addTag(new Tag("data1","123"));
		$tag->addTag(new Tag("data2","456"));
		$tag->addTag(new Tag("data3","789"));		
		$this->tagUtil->insert(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);

		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		
		$count = 1;
		foreach($list as $tag){
			if($count == 3){
				$this->assertEquals(4,$tag->getParameter("id"));
				break;
			}
			$count++;
		}
		$list = $this->tagUtil->sort($list,"id");

		$count = 1;
		foreach($list as $tag){
			if($count == 3){
				$this->assertEquals(3,$tag->getParameter("id"));
				break;
			}
			$count++;
		}
	}
	function testRSort(){
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new Tag("parent"));
		
		foreach($list as $tag){
			$this->assertEquals(1,$tag->getParameter("id"));
			break;
		}
		$list = $this->tagUtil->rsort($list,"id");		
		foreach($list as $tag){
			$this->assertEquals(2,$tag->getParameter("id"));
			break;		
		}
	}
	function testToObject(){
		$tag = new Tag("parent");
		$tag->addParameterValue("id",2);
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);

		$newobj = $this->tagUtil->toObject($gettag,new ClassDummy());
		$this->assertTrue(Variable::isClassType(ClassDummy,$newobj));
		$this->assertEquals("XYZ",$newobj->getAbc());
	}
}
?>