<?php
Rhaco::import("util.UnitTest");
Rhaco::import("database.DbUtil");
Rhaco::importLibrary("data.DbConnectionRhacotest");
Rhaco::importLibrary("data.Person");

class DbUtilTest extends UnitTest{
	var $dbUtil;
	var $objects;
	
	function setUp(){
		$this->ids = array();
		
		$this->dbUtil = new DbUtil(new DbConnectionRhacotest());
		
		$person = new Person();
		$person->setAge(29);
		$person->setName("kazrhaco");
		$this->objects[] = $this->dbUtil->insert($person);
		
		$person = new Person();
		$person->setAge(1);
		$person->setName("towarhaco");
		$this->objects[] = $this->dbUtil->insert($person);
		
		$this->dbUtil->commit();
	}
    function tearDown(){
		if(Variable::isClassType(DbUtil,$this->dbUtil)){
			$this->dbUtil->rollback();
			
			$criteria = new Criteria();
			$criteria->addIn(Person::columnId(),DbUtil::extractionTableColumn($this->objects,Person::columnId()));
			$this->dbUtil->delete(new Person(),$criteria);
		}
	}
	function testCount(){
		$count = $this->dbUtil->count(new Person());
		$this->assertTrue($count > 0);
		
		$person = new Person();
		$person->setAge(1);
		$person->setName("towa");
		$this->objects[] = $this->dbUtil->insert($person);

		$this->assertEquals($count+1,$this->dbUtil->count(new Person()));
	}
	function testSelect(){
		$criteria = new Criteria();
		$criteria->addLike(Person::columnName(),".*rhaco");
		$list = $this->dbUtil->select(new Person(),$criteria);
		
		$this->assertTrue(sizeof($list) >= 2);
		
		foreach($list as $object){
			$this->assertTrue(strpos($object->getName(),"rhaco") > 0);
		}
	}
	function testInsert(){
		$count = $this->dbUtil->count(new Person());		
		
		$person = new Person();
		$person->setAge(1);
		$person->setName("towa");
		$this->objects[] = $this->dbUtil->insert($person);
		
		$this->assertEquals($count+1,$this->dbUtil->count(new Person()));
	}
	function testUpdate(){
		$criteria = new Criteria();
		$criteria->addIn(Person::columnId(),DbUtil::extractionTableColumn($this->objects,Person::columnId()));

		$person = new Person();
		$person->setAge(1);
		$person->setName("towa");

		$this->dbUtil->update($person,$criteria);
		$list = $this->dbUtil->select(new Person(),$criteria);

		$this->assertEquals(2,sizeof($list));		
		foreach($list as $object){
			$this->assertEquals("towa",$object->getName());
		}		
	}
	function testDelete(){
		$criteria = new Criteria();
		$criteria->addIn(Person::columnId(),DbUtil::extractionTableColumn($this->objects,Person::columnId()));

		$count = $this->dbUtil->count(new Person(),$criteria);
		$this->assertEquals(2,$count);
		
		$this->dbUtil->delete(new Person(),$criteria);
		$count = $this->dbUtil->count(new Person(),$criteria);
		$this->assertEquals(0,$count);
	}
	function testTransaction(){
		$criteria = new Criteria();
		$criteria->addIn(Person::columnId(),DbUtil::extractionTableColumn($this->objects,Person::columnId()));

		$this->assertEquals(2,$this->dbUtil->count(new Person(),$criteria));
		
		$this->dbUtil->delete(new Person(),$criteria);
		$this->assertEquals(0,$this->dbUtil->count(new Person(),$criteria));
		
		$this->dbUtil->rollback();

		$this->assertEquals(2,$this->dbUtil->count(new Person(),$criteria));

		$this->dbUtil->delete(new Person(),$criteria);
		$this->assertEquals(0,$this->dbUtil->count(new Person(),$criteria));
		
		$this->dbUtil->commit();
		$this->dbUtil->rollback();
		$this->assertEquals(0,$this->dbUtil->count(new Person(),$criteria));		
	}
	function testAlldelete(){
		$this->assertEquals(2,$this->dbUtil->count(new Person()));		
		$this->dbUtil->alldelete(new Person());
		$this->assertEquals(0,$this->dbUtil->count(new Person()));
	}
}
?>