<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssChannel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssImage09.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssItem.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/DateUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.3
 */
class RssChannel09 extends RssChannel{
	var $language = "";
	
	var $copyright = "";
	var $docs = "";
	var $lastBuildDate = "";
	var $managingEditor = "";
	var $pubDate = "";
	var $webMaster = "";
	
	var $skipDaysList = array();
	var $skipHoursList = array();
	
	var $imageList = array();
	var $itemList = array();
	var $textinputList = array();

	function RssChannel09($title="",$description="",$link="",$language=""){
		parent::RssChannel($title,$description,$link);
		$this->setLanguage($language);
	}
	function _set($tag){
		$src = $tag->get();
		
		foreach($tag->getIn("language") as $intag){
			$this->setLanguage($intag->getValue());
		}
		foreach($tag->getIn("copyright") as $intag){
			$this->setCopyright($intag->getValue());
		}
		foreach($tag->getIn("docs") as $intag){
			$this->setDocs($intag->getValue());
		}
		foreach($tag->getIn("lastBuildDate") as $intag){
			$this->setLastBuildDate($intag->getValue());
		}
		foreach($tag->getIn("managingEditor") as $intag){
			$this->setManagingEditor($intag->getValue());
		}
		foreach($tag->getIn("pubDate") as $intag){
			$this->setPubDate($intag->getValue());
		}
		foreach($tag->getIn("webMaster") as $intag){
			$this->setWebMaster($intag->getValue());
		}
		foreach($tag->getIn("skipDays") as $intag){
			foreach($tag->getIn("day") as $inintag){
				$this->skipDaysList[] = $inintag->get();
			}
		}
		foreach($tag->getIn("skipHours") as $intag){
			foreach($tag->getIn("hour") as $inintag){
				$this->skipHours[] = $inintag->get();
			}
		}
		foreach($tag->getIn("image") as $intag){
			$data = new RssImage09();
			$data->set($intag->get());
			$this->imageList[] = $data;
			
			$src = str_replace($intag->getPlain(),"",$src);			
		}
		foreach($tag->getIn("textinput") as $intag){
			$data = new RssTextinput();
			$data->set($intag->get());
			$this->textinputList[] = $data;

			$src = str_replace($intag->getPlain(),"",$src);						
		}
		foreach($tag->getIn("item") as $intag){
			$data = new RssItem();
			$data->set($intag->get());
			$this->itemList[] = $data;
			
			$src = str_replace($intag->getPlain(),"",$src);			
		}
		parent::_set(new Tag("channel",$src));
	}
	function _get($outTag){
		$outTag = parent::_get($outTag);
		
		$tag = new Tag("language");
		$tag->setValue($this->getLanguage());
		$outTag->addValue($tag->get());

		$tag = new Tag("copyright");
		$tag->setValue($this->getCopyright());
		$outTag->addValue($tag->get());
		
		$tag = new Tag("docs");
		$tag->setValue($this->getDocs());
		$outTag->addValue($tag->get());

		if(intval($this->lastBuildDate) > 0){
			$tag = new Tag("lastBuildDate");
			$tag->setValue($this->getLastBuildDate());
			$outTag->addValue($tag->get());
		}
		if(intval($this->pubDate) > 0){		
			$tag = new Tag("pubDate");
			$tag->setValue($this->getPubDate());
			$outTag->addValue($tag->get());
		}				
		$tag = new Tag("managingEditor");
		$tag->setValue($this->getManagingEditor());
		$outTag->addValue($tag->get());

		$tag = new Tag("webMaster");
		$tag->setValue($this->getWebMaster());
		$outTag->addValue($tag->get());

		$tag = new Tag("skipDays");
		foreach($this->getSkipDaysList() as $data){
			$intag = new Tag("day");
			$intag->setValue($data);
			$tag->addValue($intag->get());
		}
		$tag = new Tag("skipHours");
		foreach($this->getSkipHoursList() as $data){
			$intag = new Tag("hour");
			$intag->setValue($data);
			$tag->addValue($intag->get());
		}
		foreach($this->getImageList() as $data){
			if(Variable::isClassType(RssImage09,$data)){
				$outTag->addValue($data->get());
			}
		}
		foreach($this->getTextinputList() as $data){
			if(Variable::isClassType(RssTextinput,$data)){
				$outTag->addValue($data->get());
			}
		}
		foreach($this->getItemList() as $data){
			if(Variable::isClassType(RssItem,$data)){
				$outTag->addValue($data->get());
			}
		}
		return $outTag;
	}
	
	function setLanguage($value){
		$this->language = $value;
	}
	function getLanguage(){
		return $this->language;
	}
	function setCopyright($value){
		$this->copyright = $value;
	}
	function getCopyright(){
		return $this->copyright;
	}
	function setDocs($value){
		$this->docs = $value;
	}
	function getDocs(){
		return $this->docs;
	}
	function setLastBuildDate($value){
		$this->lastBuildDate = DateUtil::parseString($value);;
	}
	function getLastBuildDate(){
		return DateUtil::formatW3C($this->lastBuildDate);
	}
	function setManagingEditor($value){
		$this->managingEditor = $value;
	}
	function getManagingEditor(){
		return $this->managingEditor;
	}
	function setPubDate($value){
		$this->pubDate = DateUtil::parseString($value);
	}
	function getPubDate(){
		return DateUtil::formatW3C($this->pubDate);
	}
	function setWebMaster($value){
		$this->webMaster = $value;
	}
	function getWebMaster(){
		return $this->webMaster;
	}	
	function addSkipDaysList($value){
		$this->skipDaysList[] = $value;
	}
	function getSkipDaysList(){
		return $this->skipDaysList;
	}
	function addSkipHoursList($value){
		$this->skipHoursList[] = $value;
	}
	function getSkipHoursList(){
		return $this->skipHoursList;
	}
	function getImageList(){
		return $this->imageList;
	}
	function getItemList(){
		return $this->itemList;
	}
	function getTextinputList(){
		return $this->textinputList;
	}		
	function addItem($title,$description="",$link="",$about=""){
		$this->itemList[] = new RssItem($title,$description,$link,$about);
	}
	function addImage($title,$url,$link="",$about=""){
		$this->imageList[] = new RssImage($title,$url,$link,$about);
	}
	function addTextinput($title,$name,$description="",$link="",$about=""){
		$this->textinputList[] = new RssTextinput($title,$name,$description,$link,$about);
	}
}