<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Rss.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssChannel10.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssItem10.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssImage10.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssTextinput10.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Http.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.1
 */
class Rss10 extends Rss{
	var $itemList = array();
	var $imageList = array();
	var $textinputList = array();	

	function set($src){
		$this->itemList		= array();
		$this->imageList		= array();
		$this->textinputList	= array();

		$tag		= new Tag();
		if(!$tag->set($src,"rdf:RDF")){
			return false;
		}		
		foreach($tag->getIn("channel") as $intag){
			$data = new RssChannel10();
			$data->set($intag->get());
			$this->channel = $data;
		}
		foreach($tag->getIn("image") as $intag){
			$data = new RssImage10();
			$data->set($intag->get());
			$this->imageList[] = $data;
		}
		foreach($tag->getIn("textinput") as $intag){
			$data = new RssTextinput();
			$data->set($intag->get());
			$this->textinputList[] = $data;
		}
		foreach($tag->getIn("item") as $intag){
			$data = new RssItem10();
			$data->set($intag->get());
			$this->itemList[] = $data;
		}
		return true;
	}
	function get(){
		$outTag	= new Tag("rdf:RDF");
		$outTag->addParameterValue("xmlns:rdf","http://www.w3.org/1999/02/22-rdf-syntax-ns#");
		$outTag->addParameterValue("xmlns","http://purl.org/rss/1.0/");		
		
		if(Variable::isClassType(RssChannel10,$this->getChannel())){
			$image		= "";
			$items		= "";
			$textinput	= "";

			$channel					= $this->getChannel();
			$channel->imageList		= array();
			$channel->itemsList		= array();
			$channel->textinputList	= array();

			foreach($this->getImageList() as $data){
				if(Variable::isClassType(RssImage10,$data)){
					$image .= $data->get();
					$channel->addImageList($data->getAbout());
				}
			}
			foreach($this->getTextinputList() as $data){
				if(Variable::isClassType(RssTextinput10,$data)){
					$textinput .= $data->get();
					$channel->addTexinputList($data->getAbout());
				}
			}
			foreach($this->getItemList() as $data){
				if(Variable::isClassType(RssItem10,$data)){
					$items .= $data->get();
					$channel->addItemsList($data->getAbout());
				}
			}
			$outTag->addValue($channel->get());
			$outTag->addValue($image);
			$outTag->addValue($items);
			$outTag->addValue($textinput);
		}
		return $outTag->get();
	}	
	function setChannel($title,$description="",$link="",$about=""){
		$this->channel = new RssChannel10($title,$description,$link,$about);
	}
	function addItem($title,$description="",$link="",$about=""){
		$this->itemList[] = new RssItem10($title,$description,$link,$about);
	}
	function addImage($title,$url,$link="",$about=""){
		$this->imageList[] = new RssImage10($title,$url,$link,$about);
	}
	function addTextinput($title,$name,$description="",$link="",$about=""){
		$this->textinputList[] = new RssTextinput10($title,$name,$description,$link,$about);
	}
	function getItemList(){
		return $this->itemList;
	}
	function getImageList(){
		return $this->imageList;
	}
	function getTextinputList(){
		return $this->textinputList;
	}
}
?>