<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagParser.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.3.6
 */
class TemplateParser extends TagParser{
	var $replaceSource	= array();
	var $replaceDesc		= array();
	var $blockList		= array();
	
	function addReplace($src,$desc){
		$this->replaceSource[]	= $src;
		$this->replaceDesc[]		= $desc;
	}
	function addBlockTemplate($templateFileName){
		$this->blockList[] = $templateFileName;
	}
	function _system1000_Comment($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("comment"))){
			$src = str_replace($tag->getPlain(),"",$src);
		}
		return $src;
	}
	function _system1001_Template($src){
		$tag	= new Tag();
		$value	= "";
		$bool	= false;

		while($tag->set($src,$this->_getTagName("template"))){
			$value	.= $tag->getRawValue();
			$bool	= true;
			$src		= str_replace($tag->getPlain(),"",$src);
		}
		if($bool){
			return $value;
		}
		return $src;
	}
	function _system1002_Block($src){
		$tag					= new Tag();
		$blockList			= array();

		foreach($this->blockList as $blockTemplateFile){
			$blockTemplateSrc = $this->_getTemplateSource($this->_getTemplatePath($blockTemplateFile));

			$newtag = new Tag("template");
			$newtag->addValue($blockTemplateSrc);
			
			foreach($newtag->getIn($this->_getTagName("block")) as $blocktag){
				$blockList[strtolower($blocktag->getParameter("id","id"))]	= $blocktag->getRawValue();
			}
		}

		while($tag->set($src,$this->_getTagName("block"))){
			$id		= strtolower($tag->getParameter("id","id"));
			$value	= $tag->getRawValue();

			if(!empty($blockList[$id])){
				$value = $blockList[$id];
			}
			$src = str_replace($tag->getPlain(),$value,$src);			
		}		
		return $src;
	}
	function _system1003_Replace($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("replace"))){
			$src = str_replace($tag->getParameter("src"),$tag->getParameter("desc"),$src);			
			$src = str_replace($tag->getPlain(),"",$src);
		}
		foreach($this->replaceSource as $key => $source){
			$src = str_replace($source,$this->replaceDesc[$key],$src);
		}
		return $src;
	}
	function _system1004_ReplaceVariable($src){
		if(preg_match_all("/<([\w\d:_-]+)[\s\t][^>]*?var=([\"\'])[^\\2]*?\\2[^>]*?>/i",$src,$tagList)){
			foreach($tagList[0] as $id => $plain){
				$tag	 = new Tag();
				$tag	->set(substr($src,strpos($src,$plain)),$tagList[1][$id]);

				if($tag->isParameter("var")){
					$plain	= $tag->getPlain();
					$var		= $tag->getParameter("var");

					$tag->removeParameter("var");
					$tag->setValue($var);
					$src = str_replace($plain,$tag->get(),$src);
				}
			}
		}
		return $src;
	}	
	function _toTag1001_Loop($src){
		if(preg_match_all("/\{#loop\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					$param = "class";
					
					if($counter == 1){		$param = "id";		}
					else if($counter == 2){	$param = "limit";	}						
					else if($counter == 3){	$param = "offset";	}

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("loop").$val.">",$src);
			}
			$src = str_replace("{#endloop}","</".$this->_getTagName("loop").">",$src);
		}
		return $src;
	}
	function _toTag1002_Keyloop($src){
		if(preg_match_all("/\{#keyloop\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					$param = "class";
					
					if($counter == 1){		$param = "key";		}
					else if($counter == 2){	$param = "limit";	}						
					else if($counter == 3){	$param = "offset";	}

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("loop").$val.">",$src);
			}
			$src = str_replace("{#endkeyloop}","</".$this->_getTagName("loop").">",$src);
		}
		return $src;
	}
	function _toTag1003_For($src){
		if(preg_match_all("/\{#for\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					$param = "id";
					
					if($counter == 1){		$param = "start";	}
					else if($counter == 2){	$param = "end";		}						
					else if($counter == 3){	$param = "step";		}

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("for").$val.">",$src);
			}
			$src = str_replace("{#endfor}","</".$this->_getTagName("for").">",$src);
		}
		return $src;
	}
	function _toTag1004_If($src){
		if(preg_match_all("/\{#if\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					if($counter == 0){		$param = "target";	}
					else if($counter == 1){	$param = "value";	}						

					$value = preg_replace("/^\"/","",$value);
					$value = preg_replace("/\"$/","",$value);
					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("if").$val.">",$src);
			}
			$src = str_replace("{#else}","<".$this->_getTagName("else")." />",$src);
			$src = str_replace("{#endif}","</".$this->_getTagName("if").">",$src);
		}
		return $src;		
	}
	function _toTag1005_IfNot($src){
		if(preg_match_all("/\{#ifnot\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					if($counter == 0){		$param = "target";	}
					else if($counter == 1){	$param = "value";	}						
					$value = preg_replace("/^\"/","",$value);
					$value = preg_replace("/\"$/","",$value);					

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("ifnot").$val.">",$src);
			}
			$src = str_replace("{#else}","<".$this->_getTagName("else")." />",$src);
			$src = str_replace("{#endifnot}","</".$this->_getTagName("ifnot").">",$src);
		}
		return $src;
	}
	function _exec1001_Loop($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("loop"))){
			$class	= $this->_parsePlainVariable($tag->getParameter("class","class"));
			$key		= $tag->getParameter("key","key");
			$id		= $tag->getParameter("id","id");
			$counter	= $this->_getVariableString($tag->getParameter("counter","counter"));
			$offset	= $tag->getParameter("offset","1");
			$limit	= $tag->getParameter("limit","0");

			$offsetName	= sprintf("\$_OFFSET_%s",$this->_variableQuote($class));
			$limitName	= sprintf("\$_LIMIT_%s",$this->_variableQuote($class));

			$function	= sprintf("%s%s = 1;%s",$this->_getPhpTagStart(),$counter,$this->_getPhpTagEnd());
			$function	.= sprintf("%s %s = %d;%s",$this->_getPhpTagStart(),$offsetName,$offset,$this->_getPhpTagEnd());
			$function	.= sprintf("%s %s = %d;%s",$this->_getPhpTagStart(),$limitName,(($limit>0)?($offset + $limit):0),$this->_getPhpTagEnd());
			$function	.= sprintf("%sif(is_array(%s)):%s",$this->_getPhpTagStart(),$this->_getVariableString($class),$this->_getPhpTagEnd());
			$function	.= sprintf("%sforeach(%s as %s => %s):%s",$this->_getPhpTagStart(),$this->_getVariableString($class),$this->_getVariableString($key),$this->_getVariableString($id),$this->_getPhpTagEnd());
			$function	.= sprintf("%sif(%s <= %s):%s",$this->_getPhpTagStart(),$offsetName,$counter,$this->_getPhpTagEnd());
			$function	.= sprintf("%s",$tag->getRawValue());
			$function	.= sprintf("%sendif;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			$function	.= sprintf("%s%s++;%s",$this->_getPhpTagStart(),$counter,$this->_getPhpTagEnd());
			$function	.= sprintf("%sif(%s > 0 && %s >= %s){break;}%s",$this->_getPhpTagStart(),$limitName,$counter,$limitName,$this->_getPhpTagEnd());
			$function	.= sprintf("%sendforeach;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			$function	.= sprintf("%sendif;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());

			$src = str_replace($tag->getPlain(),$function,$src);
		}		
		return $src;
	}
	function _exec1002_For($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("for"))){
			$counterName	= $this->_getVariableString($tag->getParameter("id","counter"));
			$start		= intval($tag->getParameter("start",0));
			$end			= intval($tag->getParameter("end",10));
			$step		= intval($tag->getParameter("step",1));
			
			$function = sprintf("%s for(%s=%d;%s<=%d;%s+=%d): %s",
								$this->_getPhpTagStart(),								
								$counterName,
								$start,
								$counterName,
								$end,
								$counterName,
								$step,
								$this->_getPhpTagEnd()
							);
			$function .= $tag->getRawValue();
			$function .= sprintf("%s endfor; %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			
			$src = str_replace($tag->getPlain(),$function,$src);
		}		
		return $src;
	}
	function _exec1003_If($src){
		$tag = new Tag();
		
		while($tag->set($src,$this->_getTagName("if"))){
			$arg1		= $this->_parsePlainVariable($tag->getParameter("target"));
			$value		= $tag->getRawValue();
			$pattern		= "";
			$parse		= array();
			
			if(!is_bool($arg1) && !preg_match("/^[\$\'\"]/",$arg1)){
				$arg1 = sprintf("'%s'",$arg1);
			}
			if($tag->isParameter("value")){
				$arg2 = $this->_parsePlainVariable($tag->getParameter("value"));							
				if(!preg_match("/^([\$\'\"])/",$arg2)){
					$arg2 = sprintf("'%s'",$arg2);
				}
				$pattern = sprintf("%s == %s",$arg1,$arg2);
			}else{
				$pattern = sprintf("%s",$arg1);
			}
			$function	= sprintf("%s if(%s): %s",$this->_getPhpTagStart(),$pattern,$this->_getPhpTagEnd());
			
			if(preg_match("/(<[\s\t]*".$this->_getTagName("else")."[^>]*[\s\t]*\/>)/i",$tag->getRawValue(),$parse)){
				$value	= str_replace($parse[1],
								sprintf("%s else: %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd()),
								$value
							);
			}
			$function	.= sprintf("%s",$value);
			$function	.= sprintf("%s endif; %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			
			$src = str_replace($tag->getPlain(),$function,$src);			
		}
		return $src;
	}
	function _exec1004_IfNot($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("ifnot"))){
			$arg1		= $this->_parsePlainVariable($tag->getParameter("target"));
			$value		= $tag->getRawValue();
			$pattern		= "";
			$parse		= array();

			if(!is_bool($arg1) && !preg_match("/^([\$\'\"])/",$arg1)){
				$arg1 = sprintf("\"%s\"",$arg1);
			}
			if($tag->isParameter("value")){
				$arg2 = $this->_parsePlainVariable($tag->getParameter("value"));							
				if(!preg_match("/^([\$\'\"])/",$arg2)){
					$arg2 = sprintf("\"%s\"",$arg2);
				}
				$pattern = sprintf("%s != %s",$arg1,$arg2);
			}else{
				$pattern = sprintf("!%s",$arg1);
			}
			$function	= sprintf("%s if(%s): %s",$this->_getPhpTagStart(),$pattern,$this->_getPhpTagEnd());
			
			if(preg_match("/(<[\s\t]*".$this->_getTagName("else")."[^>]*[\s\t]*\/>)/i",$tag->getRawValue(),$parse)){
				$value	= str_replace($parse[1],
								sprintf("%s else: %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd()),
								$value
							);
			}
			$function	.= sprintf("%s",$value);
			$function	.= sprintf("%s endif; %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());

			$src = str_replace($tag->getPlain(),$function,$src);
		}
		return $src;
	}
	function _exec1005_invalid($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("invalid"))){
			$name		= $this->_parsePlainVariable($tag->getParameter("name","exceptions"));
			$errors		= $this->_parsePlainVariable($tag->getParameter("errors","errors"));			
			$join		= $this->_parsePlainVariable($tag->getParameter("join","\n"));
			$function	= $tag->getPlain();

			if(!empty($name)){
				$function	= sprintf("%sif(ExceptionTrigger::invalid(\"%s\")):%s",$this->_getPhpTagStart(),$name,$this->_getPhpTagEnd());
				$function	.= sprintf("%s%s = \"\";%s",$this->_getPhpTagStart(),$this->_getVariableString($errors),$this->_getPhpTagEnd());
				$function	.= sprintf("%s\$_INVALID_ = array();%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
				$function	.= sprintf("%sforeach(ExceptionTrigger::get(\"%s\") as \$_INVALID_EXCEPTION):%s",$this->_getPhpTagStart(),$name,$this->_getPhpTagEnd());
				$function	.= sprintf("%s\$_INVALID_[] = \$_INVALID_EXCEPTION->getMessage();%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
				$function	.= sprintf("%sendforeach;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
				$function	.= sprintf("%s%s = implode(html_entity_decode(\"%s\"),\$_INVALID_); %s",$this->_getPhpTagStart(),$this->_getVariableString($errors),addslashes($join),$this->_getPhpTagEnd());				
				$function	.= sprintf("%s",$tag->getRawValue());
				$function	.= sprintf("%sendif;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			}

			$src = str_replace($tag->getPlain(),$function,$src);
		}
		return $src;
	}

	function _getTagName($value){
		return sprintf("RT:%s",$value);
	}
	function _getCashUrl($templateFileName){
		if(!empty($templateFileName)){
			$null = null;
			$templateFileName	= preg_replace("/[\\\:]/","/",$templateFileName);
			$templateFileName	= preg_replace("/[\~\&]/","",$templateFileName);
			$base				= str_replace("\\","/",Rhaco::define("TEMPLATE_CASH_PATH",Rhaco::path("work")));

			if(!empty($base) && (!(substr($base,-1) == "/" || substr($base,-1) == "\\"))){
				$base = $base."/";
			}
			if(preg_match("/:\/\/([^\/]+)$/",$templateFileName,$null)){
				$templateFileName = sprintf("%s/index",$templateFileName);
			}else if(preg_match("/[\/\\\\]$/",$templateFileName,$null)){
				$templateFileName = sprintf("%sindex",$templateFileName);
			}
			$templateFileName = preg_replace("/[\/]+/","/",$templateFileName);
			if(substr($templateFileName,0,1) == "/"){
				$templateFileName = substr($templateFileName,1);
			}
			if(is_array($this->blockList) && sizeof($this->blockList) > 0){
				foreach($this->blockList as $blockFileName){
					$blockFileName		= preg_replace("/[^\w\d]/","",substr($blockFileName,strlen(dirname($blockFileName))));
					$templateFileName	= sprintf("%s-%s",$templateFileName,$blockFileName);
				}
			}
			return array(sprintf("%scash/%s",$base,$templateFileName),sprintf("%sexpiry/%s",$base,$templateFileName));
		}
		return array(sprintf("%scash/null",$base),sprintf("%sexpiry/null",$base));
	}
}
?>