<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class Folder{
	var $path;
	var $name;
	var $folderList = array();
	var $fileList = array();
	
	function Folder($path){
		$directory = trim($path);

		if(substr($directory,-1) == "/"){
			$directory = substr($directory,0,-1);
		}
		$this->path = $directory;
		$this->name	= pathinfo($directory,PATHINFO_BASENAME);
		
		if($handle = @opendir($directory)){
			while($pointer = readdir($handle)){
				if($pointer != "." && $pointer != ".."){
					$source = sprintf("%s/%s",$directory,$pointer);
					if(is_file($source)){
						$this->addFile(new File($source));
					}elseif(is_dir($source)){
						$this->addFolder(new Folder($source));
					}
				}
			}
			closedir($handle);
		}
	}

	function addFolder($folder){
		$this->folderList[] = $folder;
	}
	function addFile($file){
		$this->fileList[] = $file;
	}
	function getName(){
		return $this->name;
	}
	function getFolderList(){
		return $this->folderList;
	}
	function getFileList(){
		return $this->fileList;
	}
}
?>