<?php
/* ----------------------------------------------------
 * Response
 * @version 1.0.0
 * @author ken Kikuchi
 * http://www.i-approach.com/
 * 
 * Licensed under the MIT licenses.
*/ 

class AnswersController extends AppController {

	var $name = 'Answers';
	var $uses = array('Answer','Question');
	var $components = array('UserId','RoleCheck');
	var $helpers = array('Time');
	
	function index() {
		if(!$this->RoleCheck->checkAnswer('index')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		$this->Answer->recursive = 0;
		$this->params['sort'] = 'modified';
		$this->params['direction'] = 'desc';
		$this->set('answers', $this->paginate('Answer', array(array('Answer.user_id LIKE' => $this->UserId->getStudentId()) ,array('Answer.parentid LIKE' => $this->UserId->getTeacherId()))));
	}

	function view($id = null) {
		if(!$this->RoleCheck->checkAnswer('view')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid answer', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->Answer->recursive = 0;
		$this->params['direction'] = 'desc';
		$this->set('answers', $this->paginate('Answer', array(array('Answer.user_id LIKE' => $id))));
	}

	function add($id = null) {
		if(!$this->RoleCheck->checkAnswer('add')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid answer', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->data)) {
			$this->Answer->create();
			if ($this->Answer->save($this->data)) {
				$post_id = $this->Question->read('post_id', $id);
				$this->Session->setFlash(__('The answer has been saved.', true));
				$this->redirect(array('controller' => 'questions','action' => 'index',$post_id['Question']['post_id']));
			} else {
				$post_id = $this->Question->read('post_id', $id);
				$this->Session->setFlash(__('The answer could not be saved. Please, try again.', true));
				$this->redirect(array('controller' => 'questions','action' => 'index',$post_id['Question']['post_id']));
			}
		}

		$this->set('questionid', $id);
		$this->set('userid', $this->Auth->user('id'));
		$this->set('parentid', $this->Auth->user('parent_id'));
	}

	function edit($id = null) {
		if(!$this->RoleCheck->checkAnswer('edit')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid answer', true));
			$this->redirect(array('controller' => 'posts','action' => 'index'));
		}
		if (!empty($this->data)) {
			if ($this->Answer->save($this->data)) {
			$questions = $this->Question->read('post_id', $this->data['Answer']['question_id']);
			$this->redirect(array('controller' => 'questions','action' => 'index',$questions['Question']['post_id']));
			} else {
				$post_id = $this->Question->read('post_id', $id);
				$this->Session->setFlash(__('The answer could not be saved. Please, try again.', true));
				$this->redirect(array('controller' => 'questions','action' => 'index',$post_id['Question']['post_id']));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Answer->read(null, $id);
		}
		$questions = $this->Answer->Question->find('list');
		$users = $this->Answer->User->find('list');
		$this->set(compact('questions', 'users'));
	}

	function delete($id = null) {
		if(!$this->RoleCheck->checkAnswer('delete')) {
			$this->Session->setFlash(__('Invalid Access', true));
			$this->redirect(array('controller'=> 'posts','action' => 'index'));
    	}
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for answer', true));
			$this->redirect(array('action'=>'index'));
		}
			$answers = $this->Answer->read('question_id', $id);	
		if ($this->Answer->delete($id)) {
			$this->Session->setFlash(__('Answer deleted', true));
			if($this->Auth->user('role')== 4 and 5){
				$questions = $this->Question->read('post_id', $answers['Answer']['question_id']);
				$this->redirect(array('controller' => 'questions','action' => 'index',$questions['Question']['post_id']));
			}else{
				$this->redirect(array('action'=>'index'));
			}
		}
		$this->Session->setFlash(__('Answer was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}
?>