/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.dialog;

import jp.highwide.resourcechecker.widgets.StacktraceComposit;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * G[_CAÕNXB
 */
public class ErrorDialog extends Dialog {
	private Throwable e;
	/**
	 * RXgN^B
	 * @param parentShell eShell
	 * @param e \O
	 */
	public ErrorDialog(Shell parentShell, Throwable e) {
		super(parentShell);
		setShellStyle(getShellStyle() | SWT.RESIZE);
		this.e = e;
	}

	/**
	 * G[_CAÕ_CAOGA쐬B
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		getShell().setText("G[_CAO");
		Composite mainComposite = new Composite(parent, SWT.NONE);
		GridLayout layout1Collumn = new GridLayout(1, false);
		GridData fillBoth = new GridData(GridData.FILL_BOTH);
		mainComposite.setLayout(layout1Collumn);
		mainComposite.setLayoutData(fillBoth);
		mainComposite.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
		
		StacktraceComposit stacktraceComposit = new StacktraceComposit(
				mainComposite,
				e);
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.widthHint = 500;
		gridData.heightHint = 300;
		stacktraceComposit.setLayoutData(gridData);
		return parent;
	}

	/**
	 * G[_CAÕ{^쐬B
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
	}

}
