/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.action;

import java.util.ArrayList;
import java.util.Iterator;

import jp.highwide.resourcechecker.ResourceCheckerPlugin;
import jp.highwide.resourcechecker.builder.ResourceCheckerNature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * r_[Ƀ\[X`FbJ[r_[o^Eo^sactionNXB
 */
public class ToggleNatureAction implements IObjectActionDelegate {
	private ISelection selection;
	/**
	 * RXgN^B<br>
	 * ȂB
	 */
	public ToggleNatureAction() {
	}
	/**
	 * <code>run</code>ŎgpselectionێB
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	/**
	 * Ȃ
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * \[X`FbJ[r_[̃gOsB
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (selection instanceof IStructuredSelection) {
			for (Iterator it = ((IStructuredSelection) selection).iterator(); it.hasNext();) {
				Object element = it.next();
				IProject project = null;
				if (element instanceof IProject) {
					project = (IProject) element;
				} else if (element instanceof IAdaptable) {
					project = (IProject) ((IAdaptable) element).getAdapter(IProject.class);
				}
				if (project != null) {
					toggleNature(project);
				}
			}
		}
	}

	/**
	 * w肳ꂽvWFNg̃\[X`FbJ[r_[̃gOsB
	 * @param project gOsvWFNg
	 */
	private void toggleNature(IProject project) {
		if (isNature(project)) {
			removeNature(project);
		} else {
			addNature(project);
		}
	}

	/**
	 * \[X`FbJ[r_[o^Ă邩
	 * @param project `FbNvWFNg
	 * @return truȅꍇ͓o^ĂB
	 */
	public static boolean isNature(IProject project) {
		IProjectDescription description;
		try {
			description = project.getDescription();
		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
			return false;
		}

		String[] natures = description.getNatureIds();
		for (String nature : natures) {
			if (ResourceCheckerNature.NATURE_ID.equals(nature)) {
				return true;
			}
		}
		return false;
	}
	/**
	 * \[X`FbJ[r_[o^B
	 * @param project o^vWFNg
	 */
	public static void addNature(IProject project) {
		if (isNature(project)) {
			return;
		}

		try {
			IProjectDescription description = project.getDescription();
			String[] natures = description.getNatureIds();
			ArrayList<String> natureList = new ArrayList<String>();
			for (String nature : natures) {
				natureList.add(nature);
			}
			natureList.add(ResourceCheckerNature.NATURE_ID);
			description.setNatureIds(natureList.toArray(new String[0]));
			project.setDescription(description, null);
		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
		}
	}
	/**
	 * \[X`FbJ[r_[̓o^B
	 * @param project vWFNg
	 */
	public static void removeNature(IProject project) {
		try {
			IProjectDescription description = project.getDescription();
			String[] natures = description.getNatureIds();
			ArrayList<String> natureList = new ArrayList<String>();
			for (String nature : natures) {
				natureList.add(nature);
			}
			natureList.remove(ResourceCheckerNature.NATURE_ID);
			description.setNatureIds(natureList.toArray(new String[0]));
			project.setDescription(description, null);
		} catch (CoreException e) {
			ResourceCheckerPlugin.log(e);
		}
	}
}
