/* Copyright (C) 2007 HighWide. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE HIGHWIDE "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE HIGHWIDE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * -----
 * {\tgEFA"The modified BSD license"ɏ܂B
 */
package jp.highwide.resourcechecker.action;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

/**
 * <code>loadClass</code>\bhŕԋpNXLbVĂƂ\URLNX[_[B
 */
public class CacheURLClassLoader extends URLClassLoader {
	/** NX̃LbV */
	private Map<String, Class<?>> cacheClassMap = new HashMap<String, Class<?>>();
	/**
	 * RXgN^B
	 * @param urls NXу\[X̃[hƂȂ URL
	 * @param parent Ϗ̂߂̐eNX[_
	 */
	public CacheURLClassLoader(URL[] urls, ClassLoader parent) {
		super(urls, parent);
	}
	/**
	 * RXgN^B
	 * @param urls NXу\[X̃[hƂȂ URL
	 */
	public CacheURLClassLoader(URL[] urls) {
		super(urls);
	}
	/**
	 * LbVNXǉB
	 * @param targetClass LbVNX
	 */
	public void addCacheClass(Class targetClass) {
		cacheClassMap.put(targetClass.getCanonicalName(), targetClass);
	}
	/**
	 * w肳ꂽoCiNX[hB
	 * @param name NX̃oCi
	 * @return ʂ Class IuWFNg
	 * @throws ClassNotFoundException NXȂꍇ
	 * @see java.lang.ClassLoader#loadClass(java.lang.String)
	 */
	@Override
	public Class<?> loadClass(String name) throws ClassNotFoundException {
		if (cacheClassMap.get(name) != null) {
			return cacheClassMap.get(name);
		}
		return super.loadClass(name);
	}
}
