/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import net.morilib.db.engine.SqlEngine;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.dml.SqlSelect;

public class RelationReferSubquery extends RelationExpression {

	private SqlSelect select;
	private String name;

	public RelationReferSubquery(SqlSelect s) throws SQLException {
		if(s.getData().size() != 1) {
			throw ErrorBundle.getDefault(10013);
		}
		select = s;
		name   = s.getData().get(0).getAs();
		name   = name != null ? name : "0";
	}

	@Override
	public Object eval(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> group,
			List<Object> h) throws IOException, SQLException {
		RelationCursor i;
		RelationTuple t;
		Relation r;

		r = v.visit(select, tuple, h);
		i = r.iterator();
		if(i.hasNext()) {
			t = i.next();
			if(i.hasNext()) {
				throw ErrorBundle.getDefault(10014);
			}
			return t.get(name);
		} else {
			return RelationExpression.NONE;
		}
	}

	@Override
	public boolean isAggregate() {
		return false;
	}

	@Override
	public Object init(SqlEngine v, SqlSchema f) throws SQLException {
		return "";
	}

}
