/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.engine;

import net.morilib.db.schema.SqlSchema;

public abstract class SqlEngineFactory {

	private static final
	SqlEngineFactory _INS = new SqlEngineFactory() {

		public SqlEngine getEngine(SqlSchema f) {
			return new DefaultSqlEngine(f);
		}

	};

	SqlEngineFactory() {}

	public static SqlEngineFactory getInstance() {
		return _INS;
	}

	public abstract SqlEngine getEngine(SqlSchema f);

}
