/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.httpd;

import java.io.IOException;
import java.io.InputStream;

public class URLEncodedInputStream
extends InputStream {
    private S etat = S.INI;
    private InputStream ins = null;

    public void newInputStream(InputStream ins) throws IOException {
        if (this.ins != null) {
            this.ins.close();
        }
        this.ins = ins;
    }

    @Override
    public int read() throws IOException {
        int r = 0;
        if (this.ins == null) {
            throw new IllegalStateException();
        }
        block5: while (true) {
            int c = this.ins.read();
            switch (this.etat) {
                case INI: {
                    if (c < 0) {
                        return -1;
                    }
                    if (c == 43) {
                        return 32;
                    }
                    if (c == 37) {
                        this.etat = S.P01;
                        r = 0;
                        continue block5;
                    }
                    return c;
                }
                case P01: {
                    if (c >= 48 && c <= 57) {
                        this.etat = S.P02;
                        r = c - 48;
                        continue block5;
                    }
                    return 37;
                }
                case P02: {
                    if (c >= 48 && c <= 57) {
                        return r * 10 + (c - 48);
                    }
                    return 37;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.ins.close();
    }

    private static enum S {
        INI,
        P01,
        P02;

    }
}

