/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.transact;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.map.CSVDataMapper;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.transact.RelationsLock;

public class TransactionSqlSchema
implements SqlSchema,
RelationsLock {
    private SqlSchema schema;
    private Map<String, Fichier> trans = new HashMap<String, Fichier>();

    public TransactionSqlSchema(SqlSchema schema) {
        this.schema = schema;
    }

    void commit() throws IOException, SQLException {
        ArrayList<RelationTuple> l = new ArrayList<RelationTuple>();
        CSVDataMapper m = new CSVDataMapper();
        for (Map.Entry<String, Fichier> t : this.trans.entrySet()) {
            SingleTableRelation r = m.read(t.getKey(), null, this.getCreateTable(t.getKey()), t.getValue().openReader());
            RelationCursor c = r.iterator();
            while (c.hasNext()) {
                l.add(c.next());
            }
            this.schema.writeRelation(t.getKey(), l);
            t.getValue().delete();
            this.schema.unlock(t.getKey());
        }
        this.trans.clear();
    }

    void rollback() throws IOException {
        for (Map.Entry<String, Fichier> t : this.trans.entrySet()) {
            t.getValue().delete();
            this.schema.unlock(t.getKey());
        }
        this.trans.clear();
    }

    @Override
    public NamedRelation readRelation(String t, String as) throws IOException, SQLException {
        CSVDataMapper m = new CSVDataMapper();
        Fichier f = this.trans.get(t);
        if (f != null) {
            return m.read(t, as, this.getCreateTable(t), f.openReader());
        }
        return this.schema.readRelation(t, as);
    }

    @Override
    public void writeRelation(String name, Collection<RelationTuple> z) throws IOException, SQLException {
        SqlCreateTable c = this.getCreateTable(name);
        CSVDataMapper m = new CSVDataMapper();
        PrintWriter w = null;
        Fichier t = this.trans.get(name);
        try {
            w = new PrintWriter(new BufferedWriter(t.openWriter()));
            m.write(name, c, w, z);
            w.close();
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    @Override
    public SqlCreateTable getCreateTable(String name) throws IOException, SQLException {
        return this.schema.getCreateTable(name);
    }

    @Override
    public boolean isTable(String name) throws IOException, SQLException {
        return this.schema.isTable(name);
    }

    @Override
    public void putCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        this.schema.putCreateTable(name, table);
    }

    @Override
    public Collection<String> getTableNames() throws IOException, SQLException {
        return this.schema.getTableNames();
    }

    @Override
    public void truncateTable(String name) throws IOException, SQLException {
        this.schema.truncateTable(name);
    }

    @Override
    public void removeCreateTable(String name) throws IOException, SQLException {
        this.schema.removeCreateTable(name);
    }

    @Override
    public void alterCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        this.schema.alterCreateTable(name, table);
    }

    @Override
    public SqlSchema fork() {
        return this.schema.fork();
    }

    @Override
    public NullBoolean isReadonly() {
        return this.schema.isReadonly();
    }

    @Override
    public NullBoolean usesLocalFiles() {
        return this.schema.usesLocalFiles();
    }

    @Override
    public NullBoolean usesLocalFilePerTable() {
        return this.schema.usesLocalFilePerTable();
    }

    @Override
    public FabriqueDeFichier fabrique() {
        return this.schema.fabrique();
    }

    @Override
    public void bindSchema(String name, Relation r) {
        this.schema.bindSchema(name, r);
    }

    @Override
    public boolean isAutoCommit() {
        return false;
    }

    @Override
    public boolean isLocked(String name) {
        return this.schema.isLocked(name) && !this.trans.containsKey(name);
    }

    @Override
    public boolean isUsed(String name) {
        return this.schema.isUsed(name);
    }

    @Override
    public void lock(String name) throws IOException {
        if (!this.schema.isLocked(name) && !this.trans.containsKey(name)) {
            Fichier t = this.fabrique().createTempFile("pre-", ".tmp");
            this.trans.put(name, t);
            this.schema.lock(name);
        }
    }

    @Override
    public void unlock(String name) throws IOException {
        this.schema.unlock(name);
    }
}

