/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.sqlcs.dml.SqlExpression;
import net.morilib.db.sqlcs.dml.SqlOrderBy;
import net.morilib.db.sqlcs.dml.SqlRelation;
import net.morilib.db.sqlcs.dml.SqlSelectDistinct;
import net.morilib.db.sqlcs.dml.SqlSetExpression;
import net.morilib.db.sqlcs.dml.SqlTableColumn;

public class SqlSelect
implements SqlSetExpression {
    private List<SqlTableColumn> data;
    private List<SqlRelation> tables;
    private SqlExpression where;
    private List<String> groupby;
    private SqlExpression having;
    private List<SqlOrderBy> orderby;
    private SqlSelectDistinct distinct;
    private Map<String, SqlSetExpression> map;

    SqlSelect(List<SqlTableColumn> data, SqlSelectDistinct d, List<SqlRelation> tables, SqlExpression where, List<String> groupby, SqlExpression having, List<SqlOrderBy> orderby, Map<String, SqlSetExpression> m, int dum) {
        this.data = data;
        this.tables = tables;
        this.where = where;
        this.groupby = groupby;
        this.having = having;
        this.orderby = orderby;
        this.distinct = d;
        this.map = m;
    }

    public SqlSelect(List<SqlTableColumn> data, SqlSelectDistinct d, List<SqlRelation> tables, SqlExpression where, List<String> groupby, SqlExpression having, List<SqlOrderBy> orderby, Map<String, SqlSetExpression> m) {
        this(new ArrayList<SqlTableColumn>(data), d, tables != null ? new ArrayList<SqlRelation>(tables) : null, where, groupby != null ? new ArrayList<String>(groupby) : null, having, orderby != null ? new ArrayList<SqlOrderBy>(orderby) : null, (Map<String, SqlSetExpression>)(m != null ? new LinkedHashMap<String, SqlSetExpression>(m) : null), 72);
    }

    public List<SqlTableColumn> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public List<SqlRelation> getTables() {
        if (this.tables != null) {
            return Collections.unmodifiableList(this.tables);
        }
        return null;
    }

    public SqlExpression getWhere() {
        return this.where;
    }

    public List<String> getGroupby() {
        if (this.groupby != null) {
            return Collections.unmodifiableList(this.groupby);
        }
        return null;
    }

    public SqlExpression getHaving() {
        return this.having;
    }

    public List<SqlOrderBy> getOrderby() {
        if (this.orderby != null) {
            return Collections.unmodifiableList(this.orderby);
        }
        return null;
    }

    public SqlSelectDistinct getDistinct() {
        return this.distinct;
    }

    public Map<String, SqlSetExpression> getWith() {
        return this.map != null ? Collections.unmodifiableMap(this.map) : null;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("(select ");
        int d = 40;
        for (SqlTableColumn sqlTableColumn : this.data) {
            b.append((char)d).append(sqlTableColumn);
            d = 32;
        }
        b.append(") ");
        if (this.tables != null && this.tables.size() > 0) {
            d = 40;
            for (SqlRelation sqlRelation : this.tables) {
                b.append((char)d).append(sqlRelation);
                d = 32;
            }
            b.append(") ");
        } else {
            b.append("#f ");
        }
        if (this.where != null) {
            b.append(this.where).append(' ');
        } else {
            b.append("#t ");
        }
        if (this.groupby != null && this.groupby.size() > 0) {
            d = 40;
            for (String string : this.groupby) {
                b.append((char)d).append(string);
                d = 32;
            }
            b.append(") ");
        } else {
            b.append("#f ");
        }
        if (this.having != null) {
            b.append(this.having).append(' ');
        } else {
            b.append("#t ");
        }
        if (this.orderby != null && this.orderby.size() > 0) {
            d = 40;
            for (SqlOrderBy sqlOrderBy : this.orderby) {
                b.append((char)d).append(sqlOrderBy);
                d = 32;
            }
            b.append("))");
        } else {
            b.append("#f)");
        }
        return b.toString();
    }

    @Override
    public int getMaxParameter() {
        if (this.where == null) {
            return 0;
        }
        if (this.having == null) {
            return this.where.getMaxParameter();
        }
        return Math.max(this.where.getMaxParameter(), this.having.getMaxParameter());
    }
}

