/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.morilib.db.sqlcs.dml.SqlExpression;

public class SqlFunction
implements SqlExpression {
    private String name;
    private List<SqlExpression> arguments;

    public SqlFunction(String name, List<SqlExpression> args) {
        this.name = name;
        this.arguments = new ArrayList<SqlExpression>(args);
    }

    public SqlFunction(String name, SqlExpression ... args) {
        this(name, Arrays.asList(args));
    }

    public String getName() {
        return this.name;
    }

    public List<SqlExpression> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public int getMaxParameter() {
        int j = 0;
        for (SqlExpression e : this.arguments) {
            j = Math.max(j, e.getMaxParameter());
        }
        return j;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("(");
        b.append(this.name);
        for (SqlExpression e : this.arguments) {
            b.append(' ').append(e.toString());
        }
        return b.append(')').toString();
    }
}

