/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.dml;

import net.morilib.db.sqlcs.dml.SqlExpression;

public enum SqlBinaryOperator {
    ADD("(+ %s %s)"),
    SUB("(- %s %s)"),
    MUL("(* %s %s)"),
    DIV("(/ %s %s)"),
    CONCAT("(|| %s %s)"),
    EQ("(= %s %s)"),
    NE("(<> %s %s)"),
    LT("(< %s %s)"),
    LE("(<= %s %s)"),
    GT("(> %s %s)"),
    GE("(>= %s %s)"),
    AND("(and %s %s)"),
    OR("(or %s %s)"),
    LIKE("(like %s %s)");

    private String sformat;

    private SqlBinaryOperator(String f) {
        this.sformat = f;
    }

    public String toSExpression(SqlExpression a, SqlExpression b) {
        return String.format(this.sformat, a.toString(), b.toString());
    }
}

