/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.sqlcs.ddl;

import java.sql.SQLException;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.sqlcs.ddl.SqlColumnType;

public final class SqlTypeVarchar
extends SqlColumnType {
    public static final int UNLIMITED = 0;
    private int length;

    public SqlTypeVarchar(int l) {
        this.length = l;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public Object cast(String s) throws SQLException {
        return s;
    }

    @Override
    public String string(Object o) throws SQLException {
        String s = o.toString();
        if (this.length > 0 && s.length() > this.length) {
            throw ErrorBundle.getDefault(10044, new Object[0]);
        }
        return s;
    }

    @Override
    public int getSqlType() {
        return 12;
    }

    @Override
    public Class<?> getTypeClass() {
        return String.class;
    }

    public int hashCode() {
        return this.length;
    }

    public boolean equals(Object o) {
        return o instanceof SqlTypeVarchar && ((SqlTypeVarchar)o).length == this.length;
    }

    public String toString() {
        return "VARCHAR(" + this.length + ")";
    }
}

