/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class UnionAllRelation
extends AbstractRelation {
    private Relation rela;
    private Relation relb;

    public UnionAllRelation(Relation a, Relation b) throws SQLException {
        this.rela = a;
        this.relb = b;
        if (a.getColumnNames().size() != b.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        int i = 0;
        while (i < a.getColumnNames().size()) {
            if (!a.getDefinition(a.getColumnNames().get(i).getName()).isSame(b.getDefinition(b.getColumnNames().get(i).getName()))) {
                throw ErrorBundle.getDefault(10002, new Object[0]);
            }
            ++i;
        }
    }

    @Override
    public RelationCursor iterator() {
        final RelationCursor a = this.rela.iterator();
        final RelationCursor b = this.relb.iterator();
        return new RelationCursor(){

            @Override
            public boolean hasNext() {
                return b.hasNext();
            }

            @Override
            public RelationTuple next() throws IOException, SQLException {
                if (a.hasNext()) {
                    return a.next();
                }
                if (b.hasNext()) {
                    final RelationTuple t = b.next();
                    return new RelationTuple(){

                        @Override
                        public Object get(String name) throws SQLException {
                            int c = -1;
                            int i = 0;
                            while (i < UnionAllRelation.this.rela.getColumnNames().size()) {
                                if (UnionAllRelation.this.rela.getColumnNames().get(i).getName().equals(name)) {
                                    c = i;
                                }
                                ++i;
                            }
                            if (c < 0) {
                                throw ErrorBundle.getDefault(10009, name);
                            }
                            return t.get(UnionAllRelation.this.relb.getColumnNames().get(c).getName());
                        }

                        @Override
                        public RelationTuple copy() throws SQLException {
                            return new DefaultRelationTuple(this.toMap());
                        }

                        @Override
                        public Map<String, Object> toMap() throws SQLException {
                            List<SqlColumnDefinition> l = UnionAllRelation.this.rela.getColumnNames();
                            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                            int i = 0;
                            while (i < l.size()) {
                                m.put(l.get(i).getName(), this.get(l.get(i).getName()));
                                ++i;
                            }
                            return m;
                        }
                    };
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public List<SqlColumnDefinition> getColumnNames() {
        return this.rela.getColumnNames();
    }

    @Override
    public SqlColumnDefinition getDefinition(String name) {
        SqlColumnDefinition d = this.rela.getDefinition(name);
        if (d != null) {
            return d;
        }
        return null;
    }
}

