/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.Relations;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class OuterRelationTuple
implements RelationTuple {
    private Relation rel;
    private RelationTuple tuple;
    private List<SqlColumnDefinition> nulls;

    public OuterRelationTuple(Relation r, RelationTuple t, List<SqlColumnDefinition> s) throws SQLException {
        this.rel = r;
        this.tuple = t;
        this.nulls = new ArrayList<SqlColumnDefinition>(s);
    }

    @Override
    public Object get(String name) throws SQLException {
        Object o = Relations._get(this.tuple, this.rel, name);
        if (o != null) {
            return o;
        }
        if (this.nulls.contains(name)) {
            return RelationExpression.NULL;
        }
        throw ErrorBundle.getDefault(10009, name);
    }

    @Override
    public RelationTuple copy() throws SQLException {
        return new DefaultRelationTuple(this.toMap());
    }

    @Override
    public Map<String, Object> toMap() throws SQLException {
        Map<String, Object> t = this.tuple.toMap();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (SqlColumnDefinition sqlColumnDefinition : this.nulls) {
            m.put(sqlColumnDefinition.getName(), "");
        }
        for (String string : t.keySet()) {
            if (!(this.rel instanceof SingleTableRelation)) {
                m.put(string, t.get(string));
                continue;
            }
            m.put(String.valueOf(((SingleTableRelation)this.rel).getName()) + "." + string, t.get(string));
        }
        return m;
    }
}

