/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import net.morilib.db.delay.Delay;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationBinaryOperator;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public class RelationBinaryOperate
extends RelationExpression {
    private RelationBinaryOperator op;
    private RelationExpression pa;
    private RelationExpression pb;

    public RelationBinaryOperate(RelationBinaryOperator o, RelationExpression a, RelationExpression b) {
        this.op = o;
        this.pa = a;
        this.pb = b;
    }

    @Override
    public Object eval(SqlEngine v, SqlSchema f, RelationTuple tuple, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
        Object a = this.pa.eval(v, f, tuple, m, group, h);
        Object b = this.pb.eval(v, f, tuple, m, group, h);
        if (a instanceof Delay) {
            return a;
        }
        if (b instanceof Delay) {
            return b;
        }
        return this.op.op(a, b);
    }

    @Override
    public boolean isAggregate() throws SQLException {
        return this.pa.isAggregate() || this.pb.isAggregate();
    }

    @Override
    public Object init(SqlEngine v, SqlSchema f) throws SQLException {
        final Object a = this.pa.init(v, f);
        final Object b = this.pb.init(v, f);
        if (a instanceof Delay && b instanceof Delay) {
            Delay d = new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationBinaryOperate.this.op.op(((Delay)a).force(), ((Delay)b).force());
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)a).add(args);
                    ((Delay)b).add(args);
                }
            };
            return d;
        }
        if (a instanceof Delay) {
            Delay d = new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationBinaryOperate.this.op.op(((Delay)a).force(), b);
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)a).add(args);
                }
            };
            return d;
        }
        if (b instanceof Delay) {
            Delay d = new Delay(){

                @Override
                public Object force() throws SQLException {
                    return RelationBinaryOperate.this.op.op(a, ((Delay)b).force());
                }

                @Override
                public void add(Object ... args) throws SQLException {
                    ((Delay)b).add(args);
                }
            };
            return d;
        }
        return this.op.op(a, b);
    }
}

