/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.engine;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.expr.RelationBinaryOperate;
import net.morilib.db.expr.RelationBinaryOperator;
import net.morilib.db.expr.RelationConst;
import net.morilib.db.expr.RelationExists;
import net.morilib.db.expr.RelationExpression;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.expr.RelationFunctionApply;
import net.morilib.db.expr.RelationIn;
import net.morilib.db.expr.RelationInSubquery;
import net.morilib.db.expr.RelationRefer;
import net.morilib.db.expr.RelationReferSubquery;
import net.morilib.db.expr.RelationTernaryOperate;
import net.morilib.db.expr.RelationTernaryOperator;
import net.morilib.db.expr.RelationUnaryOperate;
import net.morilib.db.expr.RelationUnaryOperator;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.misc.SqlResponse;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.IsolatedRelation;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.OperatedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.Relations;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.relations.TableRelation;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.relations.VirtualCrossJoinRelation;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.schema.WithSqlSchema;
import net.morilib.db.sqlcs.ddl.SqlAlterTableAdd;
import net.morilib.db.sqlcs.ddl.SqlAlterTableDrop;
import net.morilib.db.sqlcs.ddl.SqlAlterTableModify;
import net.morilib.db.sqlcs.ddl.SqlAlterTableRenameColumn;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.db.sqlcs.ddl.SqlDropTable;
import net.morilib.db.sqlcs.ddl.SqlTruncateTable;
import net.morilib.db.sqlcs.dml.SqlBinaryOperation;
import net.morilib.db.sqlcs.dml.SqlDelete;
import net.morilib.db.sqlcs.dml.SqlExists;
import net.morilib.db.sqlcs.dml.SqlExpression;
import net.morilib.db.sqlcs.dml.SqlExpressions;
import net.morilib.db.sqlcs.dml.SqlFunction;
import net.morilib.db.sqlcs.dml.SqlIn;
import net.morilib.db.sqlcs.dml.SqlInSubquery;
import net.morilib.db.sqlcs.dml.SqlInsertSelect;
import net.morilib.db.sqlcs.dml.SqlInsertValues;
import net.morilib.db.sqlcs.dml.SqlNumeric;
import net.morilib.db.sqlcs.dml.SqlPlaceHolder;
import net.morilib.db.sqlcs.dml.SqlRelation;
import net.morilib.db.sqlcs.dml.SqlSelect;
import net.morilib.db.sqlcs.dml.SqlSetExpression;
import net.morilib.db.sqlcs.dml.SqlString;
import net.morilib.db.sqlcs.dml.SqlSubqueryLiteral;
import net.morilib.db.sqlcs.dml.SqlSymbol;
import net.morilib.db.sqlcs.dml.SqlTernaryOperation;
import net.morilib.db.sqlcs.dml.SqlUnaryOperation;
import net.morilib.db.sqlcs.dml.SqlUpdate;

public class DefaultSqlEngine
extends SqlEngine {
    public DefaultSqlEngine(SqlSchema schema) {
        super(schema);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Relation visit(SqlSelect t, RelationTuple e, List<Object> hl) throws IOException, SQLException {
        Collection<RelationTuple> l;
        LinkedHashMap<String, Object> n;
        RelationCursor c;
        SqlSchema f;
        boolean[] ag = new boolean[1];
        Relation r = null;
        Map<String, SqlSetExpression> b = t.getWith();
        if (b != null) {
            f = new WithSqlSchema(this.schema);
            for (String string : b.keySet()) {
                this.schema.bindSchema(string, this.visit(b.get(string), Collections.<Object>emptyList()));
            }
        } else {
            f = this.schema;
        }
        if (t.getTables() != null && t.getTables().size() > 0) {
            for (SqlRelation sqlRelation : t.getTables()) {
                Relation a = this.visit(sqlRelation, hl);
                Relation relation = r = r != null ? new VirtualCrossJoinRelation(r, a) : a;
            }
            if (r instanceof SingleTableRelation) {
                r = new IsolatedRelation((SingleTableRelation)r, ((SingleTableRelation)r).getName());
            } else if (r instanceof TableRenameRelation) {
                r = new IsolatedRelation(((TableRenameRelation)r).getRelation(), ((TableRenameRelation)r).getName());
            }
        } else {
            r = Relations.DUAL;
        }
        r = r.select(this, f, this.visit(t.getWhere(), hl), null, t.getDistinct(), e, null, hl);
        OperatedRelation o = Relations.operate(this, f, r, t.getData(), t.getGroupby(), hl, ag);
        if (t.getGroupby() != null && t.getGroupby().size() > 0 || ag[0]) {
            String v;
            void var21_13;
            c = o.iterator();
            while (c.hasNext()) {
                c.next();
            }
            n = new LinkedHashMap<String, Object>();
            l = t.getDistinct().create();
            ArrayList<SqlColumnDefinition> h = new ArrayList<SqlColumnDefinition>();
            boolean bl = false;
            while (var21_13 < t.getData().size()) {
                v = t.getData().get((int)var21_13).getAs();
                v = v != null ? v : String.valueOf((int)var21_13);
                String k = o.getColumnNames().get((int)var21_13).getName();
                h.add(new SqlColumnDefinition(v, o.getDefinition(k).getType(), o.getDefinition(k).getAttributes()));
                ++var21_13;
            }
            List<RelationAggregate> m = o.getMap();
            if (!m.get(0).isEmpty()) {
                for (Object object : m.get(0).keySet()) {
                    int i2 = 0;
                    while (i2 < t.getData().size()) {
                        RelationAggregate p = m.get(i2);
                        v = t.getData().get(i2).getAs();
                        String string = v = v != null ? v : String.valueOf(i2);
                        if (p.containsKey(object)) {
                            n.put(v, p.get(object).force());
                        } else {
                            n.put(v, "");
                        }
                        ++i2;
                    }
                    l.add(new DefaultRelationTuple(n));
                }
            } else if (t.getGroupby() == null || t.getGroupby().size() == 0) {
                void var21_16;
                boolean bl2 = false;
                while (var21_16 < t.getData().size()) {
                    v = t.getData().get((int)var21_16).getAs();
                    String string = v = v != null ? v : String.valueOf((int)var21_16);
                    if (m.get((int)var21_16).getInit() != null) {
                        n.put(v, m.get((int)var21_16).getInit().force());
                    } else {
                        n.put(v, Rational.ZERO);
                    }
                    ++var21_16;
                }
                l.add(new DefaultRelationTuple(n));
            }
            r = new TableRelation(h, l);
            r = r.select(this, f, this.visit(t.getHaving(), hl), null, t.getDistinct(), e, null, hl);
        } else {
            r = o;
        }
        if (t.getOrderby() != null && t.getOrderby().size() > 0) {
            ArrayList<RelationTuple> s = new ArrayList<RelationTuple>();
            c = r.iterator();
            while (c.hasNext()) {
                s.add(c.next());
            }
            RelationTuple[] d = s.toArray(new RelationTuple[0]);
            Arrays.sort(d, Relations.getComparator(r, t.getOrderby()));
            s = Arrays.asList(d);
            r = new TableRelation(r.getColumnNames(), s);
        }
        l = t.getDistinct().create();
        n = new LinkedHashMap();
        c = r.iterator();
        while (c.hasNext()) {
            RelationTuple w = c.next();
            for (SqlColumnDefinition sqlColumnDefinition : r.getColumnNames()) {
                n.put(sqlColumnDefinition.getName(), w.get(sqlColumnDefinition.getName()));
            }
            l.add(new DefaultRelationTuple(n));
        }
        r = new TableRelation(r.getColumnNames(), l);
        return r;
    }

    @Override
    public RelationExpression visit(SqlExpression e, List<Object> h) throws SQLException {
        ArrayList<RelationExpression> l = new ArrayList<RelationExpression>();
        if (e == null) {
            return new RelationConst(Rational.ONE);
        }
        if (e instanceof SqlNumeric) {
            return new RelationConst(((SqlNumeric)e).getValue());
        }
        if (e instanceof SqlString) {
            return new RelationConst(((SqlString)e).getValue());
        }
        if (e instanceof SqlSymbol) {
            return new RelationRefer(((SqlSymbol)e).getValue());
        }
        if (e instanceof SqlSubqueryLiteral) {
            return new RelationReferSubquery(((SqlSubqueryLiteral)e).getQuery());
        }
        if (e instanceof SqlPlaceHolder) {
            int j = ((SqlPlaceHolder)e).getNumber() - 1;
            if (j < 0 || j >= h.size()) {
                throw ErrorBundle.getDefault(10036, new Object[0]);
            }
            return new RelationConst(h.get(j));
        }
        if (e instanceof SqlBinaryOperation) {
            SqlBinaryOperation b = (SqlBinaryOperation)e;
            return new RelationBinaryOperate(RelationBinaryOperator.get(b.getOperator()), this.visit(b.getOperand1(), h), this.visit(b.getOperand2(), h));
        }
        if (e instanceof SqlUnaryOperation) {
            SqlUnaryOperation u = (SqlUnaryOperation)e;
            return new RelationUnaryOperate(RelationUnaryOperator.get(u.getOperator()), this.visit(u.getOperand1(), h));
        }
        if (e instanceof SqlTernaryOperation) {
            SqlTernaryOperation t = (SqlTernaryOperation)e;
            return new RelationTernaryOperate(RelationTernaryOperator.get(t.getOperator()), this.visit(t.getOperand1(), h), this.visit(t.getOperand2(), h), this.visit(t.getOperand3(), h));
        }
        if (e instanceof SqlIn) {
            SqlIn n = (SqlIn)e;
            for (SqlExpression p : n.getValues()) {
                l.add(this.visit(p, h));
            }
            return new RelationIn(this.visit(n.getExpression(), h), l);
        }
        if (e instanceof SqlInSubquery) {
            SqlInSubquery q = (SqlInSubquery)e;
            return new RelationInSubquery(this.visit(q.getExpression(), h), q.getSelect());
        }
        if (e instanceof SqlExists) {
            return new RelationExists(((SqlExists)e).getQuery());
        }
        if (e instanceof SqlFunction) {
            for (SqlExpression p : ((SqlFunction)e).getArguments()) {
                l.add(this.visit(p, h));
            }
            return new RelationFunctionApply(RelationFunction.get(((SqlFunction)e).getName()), l);
        }
        if (e == SqlExpressions.ANY) {
            return Relations.ANY;
        }
        throw new RuntimeException();
    }

    private void locktable(String name) throws IOException, SQLException {
        if (!this.schema.isAutoCommit()) {
            if (this.schema.isLocked(name)) {
                throw ErrorBundle.getDefault(10049, name);
            }
            this.schema.lock(name);
        }
    }

    private void checkused(String name) throws IOException, SQLException {
        if (!this.schema.isAutoCommit() && this.schema.isUsed(name)) {
            throw ErrorBundle.getDefault(10049, name);
        }
    }

    @Override
    public synchronized int visit(SqlInsertValues t, List<Object> h) throws IOException, SQLException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(t.getName(), null);
        SqlCreateTable c = this.schema.getCreateTable(t.getName());
        RelationCursor j = r.iterator();
        this.locktable(t.getName());
        List<String> l = t.getColumns();
        if (l == null) {
            l = new ArrayList<String>();
            for (SqlColumnDefinition v : r.getColumnNames()) {
                l.add(v.getName());
            }
        }
        int i = 0;
        while (i < t.getExprs().size()) {
            RelationExpression x = this.visit(t.getExprs().get(i), h);
            m.put(l.get(i), x.eval(this, this.schema, Relations.NULLTUPLE, null, null, h));
            ++i;
        }
        i = 0;
        while (i < c.getColumnDefinitions().size()) {
            String s = c.getColumnDefinitions().get(i).getName();
            if (!m.containsKey(s)) {
                m.put(s, "");
            }
            ++i;
        }
        while (j.hasNext()) {
            RelationTuple p = j.next();
            if (Relations.isKey(p, m, c.getKeys())) {
                throw ErrorBundle.getDefault(10001, new Object[0]);
            }
            z.add(p);
        }
        z.add(new DefaultRelationTuple(m));
        this.schema.writeRelation(t.getName(), z);
        return 1;
    }

    @Override
    public int visit(SqlUpdate t, List<Object> h) throws IOException, SQLException {
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(t.getTable(), null);
        RelationCursor j = r.iterator();
        RelationExpression x = null;
        int n = 0;
        this.locktable(t.getTable());
        if (t.getWhere() != null) {
            x = this.visit(t.getWhere(), h);
        }
        ArrayList<RelationExpression> y = new ArrayList<RelationExpression>();
        for (SqlExpression b : t.getExpressions()) {
            y.add(this.visit(b, h));
        }
        while (j.hasNext()) {
            RelationTuple p = j.next();
            if (x != null && !x.test(this, this.schema, p, null, null, h).isTrue()) {
                z.add(p);
                continue;
            }
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(p.toMap());
            int i = 0;
            while (i < y.size()) {
                m.put(t.getNames().get(i), ((RelationExpression)y.get(i)).eval(this, this.schema, p, null, null, h));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
            ++n;
        }
        this.schema.writeRelation(t.getTable(), z);
        return n;
    }

    @Override
    public int visit(SqlDelete t, List<Object> h) throws IOException, SQLException {
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(t.getName(), null);
        RelationCursor j = r.iterator();
        RelationExpression x = null;
        int n = 0;
        this.locktable(t.getName());
        if (t.getExpression() != null) {
            x = this.visit(t.getExpression(), h);
        }
        while (j.hasNext()) {
            RelationTuple p = j.next();
            if (x != null && !x.test(this, this.schema, p, null, null, h).isTrue()) {
                z.add(p);
                continue;
            }
            ++n;
        }
        this.schema.writeRelation(t.getName(), z);
        return n;
    }

    @Override
    public Object visit(SqlCreateTable c) throws IOException, SQLException {
        this.schema.putCreateTable(c.getName(), c);
        return new SqlResponse(true, "Table created");
    }

    @Override
    public Object visit(SqlDropTable c) throws IOException, SQLException {
        this.checkused(c.getName());
        this.schema.removeCreateTable(c.getName());
        return new SqlResponse(true, "Table dropped");
    }

    @Override
    public Object visit(SqlTruncateTable c) throws IOException, SQLException {
        this.checkused(c.getName());
        this.schema.truncateTable(c.getName());
        return new SqlResponse(true, "Table truncated");
    }

    @Override
    public Object visit(SqlAlterTableAdd c) throws IOException, SQLException {
        SqlCreateTable t = this.schema.getCreateTable(c.getName());
        this.checkused(c.getName());
        List<SqlColumnDefinition> l = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        for (SqlColumnDefinition x : c.getColumnDefinitions()) {
            if (t.findColumn(x.getName()) != null) {
                throw ErrorBundle.getDefault(10005, new Object[0]);
            }
            l.add(x);
        }
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(c.getName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            for (SqlColumnDefinition x : t.getColumnDefinitions()) {
                m.put(x.getName(), v.get(x.getName()));
            }
            for (SqlColumnDefinition x : c.getColumnDefinitions()) {
                m.put(x.getName(), "");
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getName(), l);
        this.schema.alterCreateTable(c.getName(), t);
        this.schema.writeRelation(c.getName(), z);
        return new SqlResponse(true, "Table columns added");
    }

    @Override
    public Object visit(SqlAlterTableModify c) throws IOException, SQLException {
        List<SqlColumnDefinition> p;
        SqlCreateTable t = this.schema.getCreateTable(c.getName());
        this.checkused(c.getName());
        List<SqlColumnDefinition> l = p = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        for (SqlColumnDefinition x : c.getColumnDefinitions()) {
            SqlColumnDefinition y = t.findColumn(x.getName());
            if (y == null) {
                throw ErrorBundle.getDefault(10006, new Object[0]);
            }
            l.set(l.indexOf(y), x);
        }
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(c.getName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            int i = 0;
            while (i < l.size()) {
                m.put(l.get(i).getName(), v.get(p.get(i).getName()));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getName(), l);
        this.schema.alterCreateTable(c.getName(), t);
        this.schema.writeRelation(c.getName(), z);
        return new SqlResponse(true, "Table columns modified");
    }

    @Override
    public Object visit(SqlAlterTableDrop c) throws IOException, SQLException {
        SqlCreateTable t = this.schema.getCreateTable(c.getName());
        this.checkused(c.getName());
        List<SqlColumnDefinition> l = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        for (String x : c.getColumnNames()) {
            SqlColumnDefinition y = t.findColumn(x);
            if (y == null) {
                throw ErrorBundle.getDefault(10006, new Object[0]);
            }
            l.remove(y);
        }
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(c.getName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            int i = 0;
            while (i < l.size()) {
                m.put(l.get(i).getName(), v.get(l.get(i).getName()));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getName(), l);
        this.schema.alterCreateTable(c.getName(), t);
        this.schema.writeRelation(c.getName(), z);
        return new SqlResponse(true, "Table columns dropped");
    }

    @Override
    public Object visit(SqlAlterTableRenameColumn c) throws IOException, SQLException {
        List<SqlColumnDefinition> p;
        SqlCreateTable t = this.schema.getCreateTable(c.getTableName());
        this.checkused(c.getTableName());
        List<SqlColumnDefinition> l = p = t.getColumnDefinitions();
        l = new ArrayList<SqlColumnDefinition>(l);
        SqlColumnDefinition y = t.findColumn(c.getColumnNameFrom());
        if (y == null) {
            throw ErrorBundle.getDefault(10006, new Object[0]);
        }
        SqlColumnDefinition d = new SqlColumnDefinition(c.getColumnNameTo(), y.getType(), y.getAttributes());
        l.set(l.indexOf(y), d);
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(c.getTableName(), null);
        RelationCursor s = r.iterator();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        while (s.hasNext()) {
            RelationTuple v = s.next();
            int i = 0;
            while (i < l.size()) {
                m.put(l.get(i).getName(), v.get(p.get(i).getName()));
                ++i;
            }
            z.add(new DefaultRelationTuple(m));
        }
        t = new SqlCreateTable(c.getTableName(), l);
        this.schema.alterCreateTable(c.getTableName(), t);
        this.schema.writeRelation(c.getTableName(), z);
        return new SqlResponse(true, "Table column renamed");
    }

    @Override
    public int visit(SqlInsertSelect t, List<Object> h) throws IOException, SQLException {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        ArrayList<RelationTuple> z = new ArrayList<RelationTuple>();
        NamedRelation r = this.schema.readRelation(t.getName(), null);
        SqlCreateTable c = this.schema.getCreateTable(t.getName());
        this.locktable(t.getName());
        Relation v = this.visit(t.getSelect(), Relations.NULLTUPLE, h);
        if (t.getColumns().size() != r.getColumnNames().size()) {
            throw ErrorBundle.getDefault(10002, new Object[0]);
        }
        RelationCursor j = r.iterator();
        while (j.hasNext()) {
            z.add(j.next());
        }
        RelationCursor k = v.iterator();
        int w = 0;
        while (k.hasNext()) {
            RelationTuple q = k.next();
            int i = 0;
            while (i < t.getColumns().size()) {
                m.put(t.getColumns().get(i), q.get(v.getColumnNames().get(i).getName()));
                ++i;
            }
            j = r.iterator();
            while (j.hasNext()) {
                RelationTuple p = j.next();
                if (!Relations.isKey(p, m, c.getKeys())) continue;
                throw ErrorBundle.getDefault(10001, new Object[0]);
            }
            z.add(new DefaultRelationTuple(m));
            ++w;
        }
        this.schema.writeRelation(t.getName(), z);
        return w;
    }

    @Override
    public void commit() throws IOException, SQLException {
    }

    @Override
    public void rollback() throws IOException, SQLException {
    }
}

