unit UNsmUtils;

interface

uses
  Windows, SysUtils, StrUtils, UWideUtils, Graphics;

function ExtractModuleType(const ModuleName: String): String;
function ExtractProtocolName(const ModuleName: String): String;

function ExtractHostDomain(const Url: String): String;
function IsUrl(const S: String): Boolean;
function Is2chUrl(const Url: String): Boolean;

function GetNextParam(var Params: String; const Delimiter: String): String;
function GetNextParamW(var Params: WideString; const Delimiter: WideString): WideString;

function LoadStringFromFile(const FileName: String; MaxLength: Integer = 64 * 1024): String;
function LoadStringFromFileW(const FileName: String; MaxLength: Integer = 64 * 1024): WideString;
procedure SaveStringToFile(const FileName, Str: String);
procedure SaveStringToFileW(const FileName, Str: WideString);

function HtmlToText(Html: WideString): WideString;

function RGBSwap(const Source: Cardinal): Cardinal;

function EncodePassword(const Source: String): String;
function DecodePassword(const Source: String): String;

function EncodeControlChar(const Source: WideString): WideString;
function DecodeControlChar(const Source: WideString): WideString;

function EncodeSpace(const Source: WideString): WideString;
function DecodeSpace(const Source: WideString): WideString;

implementation

// [gW[Ԃ
function ExtractModuleType(const ModuleName: String): String;
var
  P: Integer;
begin
  P := Pos('/', ModuleName);
  if P > 0 then
    Result := Copy(ModuleName, 1, P - 1)
  else
    Result := ModuleName;
end;

// W[vgRԂ
function ExtractProtocolName(const ModuleName: String): String;
var
  P: Integer;
begin
  P := Pos('/', ModuleName);
  if P > 0 then
    Result := Copy(ModuleName, P + 1, Length(ModuleName) - P)
  else
    Result := '';
end;

// URL zXghC𒊏o
function ExtractHostDomain(const Url: String): String;
var
  P: Integer;
begin
  Result := Url;
  P := AnsiPos('://', Result);
  if P > 0 then
    Result := Copy(Result, P + 3, Length(Result));
  P := AnsiPos('/', Result);
  if P > 0 then
    Result := Copy(Result, 1, P - 1);
end;

// 2ch  URL 
function Is2chUrl(const Url: String): Boolean;
var
  Host: String;
begin
  Host := ExtractHostDomain(Url);
  Result := (IsUrl(Url)) and
            ((AnsiContainsStr(Host, '.2ch.net') and
              not AnsiContainsStr(Host, 'www.2ch.net'))or
             (AnsiContainsStr(Host, '.bbspink.com') and
              not AnsiContainsStr(Host, 'www.bbspink.com')) or
             (AnsiContainsStr(Host, '.machibbs.com') and
              not AnsiContainsStr(Host, 'www.machibbs.com')));
end;

function IsUrl(const S: String): Boolean;
begin
  Result := AnsiStartsText('http://', S) or
            AnsiStartsText('https://', S) or
            AnsiStartsText('ftp://', S);
end;

// Params ̏߂ŏ Delimiter ܂ł̕ԂB
// ߂l̕ƍŏ Delimiter  Params 폜B
function GetNextParam(var Params: String; const Delimiter: String): String;
var
  P, PLen, DLen: Integer;
begin
  P := AnsiPos(Delimiter, Params);
  PLen := Length(Params);
  DLen := Length(Delimiter);
  if P > 0 then
  begin
    Result := Copy(Params, 1, P - 1);
    Params := Copy(Params, P + DLen, PLen - (P + DLen) + 1);
  end else
  begin  
    Result := Params;
    Params := '';
  end;
end;

function GetNextParamW(var Params: WideString; const Delimiter: WideString): WideString;
var
  P, PLen, DLen: Integer;
begin
  P := WidePos(Delimiter, Params);
  PLen := Length(Params);
  DLen := Length(Delimiter);
  if P > 0 then
  begin
    Result := WideCopy(Params, 1, P - 1);
    Params := WideCopy(Params, P + DLen, PLen - (P + DLen) + 1);
  end else
  begin  
    Result := Params;
    Params := '';
  end;
end;

// t@C當ǂݍ
function LoadStringFromFile(const FileName: String; MaxLength: Integer = 64 * 1024): String;
var
  size: Integer;
  fh: Integer;
begin
  Result := '';
  fh := FileOpen(FileName, fmOpenRead);
  if fh = 0 then Exit;
  try
    size := FileSeek(fh, 0, 2);
    if size > MaxLength then
      size := MaxLength;
    SetLength(Result, size);
    FileSeek(fh, -size, 2);
    FileRead(fh, PChar(Result)^, size);
  finally
    FileClose(fh);
  end;
end;

function LoadStringFromFileW(const FileName: String; MaxLength: Integer = 64 * 1024): WideString;
var
  size: Integer;
  fh: Integer;
begin
  Result := '';
  fh := FileOpen(FileName, fmOpenRead);
  if fh = 0 then Exit;
  try
    size := FileSeek(fh, 0, 2);
    if (MaxLength > 0) and (size > MaxLength) then
      size := MaxLength;
    SetLength(Result, size);
    FileSeek(fh, -size, 2);
    FileRead(fh, PWideChar(Result)^, size);
  finally
    FileClose(fh);
  end;
end;

procedure SaveStringToFile(const FileName, Str: String);
var
  fh: Integer;
begin
//  if FileExists(FileName) then
//    fh := FileOpen(FileName, fmOpenWrite)
//  else
  fh := FileCreate(FileName);
  if fh = 0 then Exit;
  try
    FileSeek(fh, 0, 0);
    FileWrite(fh, PChar(Str)^, Length(Str));
  finally
    FileClose(fh);
  end;
end;

procedure SaveStringToFileW(const FileName, Str: WideString);
var
  fh: Integer;
begin
//  if FileExists(FileName) then
//    fh := FileOpen(FileName, fmOpenWrite)
//  else
  fh := FileCreate(FileName);
  if fh = 0 then Exit;
  try
    FileSeek(fh, 0, 0);
    FileWrite(fh, PWideChar(Str)^, Length(Str) * 2);
  finally
    FileClose(fh);
  end;
end;

function HtmlToText(Html: WideString): WideString;
var
  I, Len: Integer;
  InTag: Boolean;
begin
  Result := '';
  InTag := False;
  Html := WideReplaceTextEx(Html, [
      WideCRLF, '', '<BR>', WideCRLF, '</P>', WideCRLF, '</DT>', WideCRLF,
      '</DD>', WideCRLF, '</TABLE>', WideCRLF, '</TD>', WideCRLF,
      '</DIV>', WideCRLF, '<HR>', WideCRLF + StringOfChar('-', 16) + WideCRLF]);
  Len := Length(Html);
  for I := 1 to Len do
  begin
    if Html[I] = '<' then
      InTag := True
    else if Html[I] = '>' then
      InTag := False
    else if not InTag and
            not ((I > 1) and (Html[I] = ' ') and (Html[I - 1] = ' ')) then
      Result := Result + Html[I];
  end;
end;

// RRGGBB <-> BBGGRR
function RGBSwap(const Source: Cardinal): Cardinal;
begin
  Result := ((Source and $FF0000) shr 16)
          +  (Source and $FF00)
          + ((Source and $FF) shl 16);
end;

const
  PassSeed = '!"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~';
  PassSeedCount = Length(PassSeed);

// [UÍEL[𐶐
function PassEncodeKey: Integer;
begin
  Result := 0;
end;

// pX[hÍ
function EncodePassword(const Source: String): String;
var
  I, J, K, L, Len, Key: Integer;
  S: Char;
  U: String;
begin
  Len := Length(Source);
  Result := '';
  U := '';
  Key := PassEncodeKey;

  for I := 1 to Len  do
  begin
    J := Random(PassSeedCount);
    U := U + PassSeed[J + 1];

    S := Source[I];
    Dec(S, $21);
    K := Integer(S);
    L := (J + K + Key + I);
    L := L mod PassSeedCount;
    U := U + PassSeed[L + 1];
  end;

 	while Length(U) > 0 do
  begin
    Result := Result + LeftStr(U, 1);
    Result := Result + RightStr(U, 1);
    Delete(U, 1, 1);
    Delete(U, Length(U), 1);
  end;
end;

function DecodePassword(const Source: String): String;
var
  I, J, K, L, Key: Integer;
  S1, S2: String;
  C: Char;
  Len: Integer;
begin
  Len := Length(Source);
  Result := '';
  if (Len = 0) then Exit;

  Key := PassEncodeKey;
  S1 := Source;
  S2 := '';
  I := 1;
  repeat
    Insert(Copy(S1, 1, 2), S2, I);
    Delete(S1, 1, 2);
    Inc(I);
  until (Length(S1) = 0);

  I := 1;
  while I <= Len do
  begin
    S1 := S2[I];
    J := Pos(S1, PassSeed) - 1;
    Inc(I);
    S1 := S2[I];
    K := Pos(S1, PassSeed) - 1;

    L := (K - J - Key - (I div 2));
    while L < 0 do
      Inc(L, PassSeedCount);
    C := Char($21 + L);

    Result := Result + String(C);
    Inc(I);
  end;
end;

// sA^uGR[h
function EncodeControlChar(const Source: WideString): WideString;
var
  I: Integer;
begin
  Result := '';
  I := 1;
  while I <= Length(Source) do
  begin
    if Source[I] = WideChar('\') then
    begin
      Result := Result + WideString('\\');
      Inc(I);
    end else
    if Source[I] = WideTab then
    begin
      Result := Result + WideString('\t');
      Inc(I);
    end else
    if (I < Length(Source)) and
       (Source[I] = WideCR) and (Source[I + 1] = WideLF) then
    begin
      Result := Result + WideString('\n');
      Inc(I, 2);
    end else
    begin
      Result := Result + Source[I];
      Inc(I);
    end;
  end;
end;

// sA^ufR[h
function DecodeControlChar(const Source: WideString): WideString;
var
  I: Integer;
begin
  Result := '';
  I := 1;
  while I <= Length(Source) do
  begin
    if (I < Length(Source)) and (Source[I] = WideChar('\')) then
    begin
      if Source[I + 1] = WideChar('\') then
        Result := Result + WideChar('\')
      else if Source[I + 1] = WideChar('t') then
        Result := Result + WideTab
      else if Source[I + 1] = WideChar('n') then
        Result := Result + WideCRLF
      else
        Result := Result + Source[I] + Source[I + 1];
      Inc(I, 2);
    end else
    begin
      Result := Result + Source[I];
      Inc(I);
    end;
  end;
end;

function EncodeSpace(const Source: WideString): WideString;
begin
  Result := WideReplaceStrEx(Source, ['%', '%25', ' ', '%20']);
end;

function DecodeSpace(const Source: WideString): WideString;
begin
  Result := WideReplaceStrEx(Source, ['%25', '%', '%20', ' ']);
end;

end.
