unit UNsmService;
(* NSM T[rX֘Ajbg *)

interface

uses
  Windows, Classes, SyncObjs, IniFiles;

type
  TNsmServiceProc = function(wParam, lParam: Cardinal): Integer; StdCall;

  TNsmServiceList = class;
  // T[rXNX
  TNsmService = class(TObject)
  private
    FOwner: TNsmServiceList;
    FProc: TNsmServiceProc;
    function GetServiceName: String;
  public
    constructor Create(AOwner: TNsmServiceList);
    property Name: String read GetServiceName;
    property ServiceProc: TNsmServiceProc read FProc write FProc;
  end;

  // T[rXXg
  TNsmServiceList = class(TObject)
  private
    FServices: THashedStringList;
    function GetCount: Integer;
    function GetService(Index: Integer): TNsmService;
  public
    constructor Create;
    destructor Destroy; override;
    property Count: Integer read GetCount;
    property Service[Index: Integer]: TNsmService read GetService; default;
    function Add(AServiceName: String; AServiceProc: TNsmServiceProc): TNsmService;
    procedure Delete(Index: Integer);
    procedure Remove(Item: TNsmService);
    procedure Clear;
    function IndexOf(ServiceName: String): Integer;
    function Find(ServiceName: String): TNsmService;
  end;

  // XbhZ[tȃT[rXXg
  TNsmThreadServiceList = class(TObject)
  private
    FServices: TNsmServiceList;
  public
    constructor Create;
    destructor Destroy; override;
    function LockList: TNsmServiceList;
    procedure UnlockList;
  end;

implementation

var
  FCriticalSection: TCriticalSection;

// TNsmService -----------------------------------------------------------------
constructor TNsmService.Create(AOwner: TNsmServiceList);
begin
  FOwner := AOwner;
end;

function TNsmService.GetServiceName: String;
var
  Idx: Integer;
begin
  Idx := FOwner.FServices.IndexOfObject(Self);
  if Idx > -1 then
    Result := FOwner.FServices[Idx];
end;

// TNsmServiceList -------------------------------------------------------------
constructor TNsmServiceList.Create;
begin
  inherited;
  FServices := THashedStringList.Create;
  FServices.Sorted := True;
end;

destructor TNsmServiceList.Destroy;
begin
  Clear;
  FServices.Free;
  inherited;
end;

function TNsmServiceList.GetCount: Integer;
begin
  Result := FServices.Count;
end;

function TNsmServiceList.GetService(Index: Integer): TNsmService;
begin
  Result := TNsmService(FServices.Objects[Index]);
end;

function TNsmServiceList.Add(AServiceName: String; AServiceProc: TNsmServiceProc): TNsmService;
begin
  if IndexOf(AServiceName) = -1 then
  begin
    Result := TNsmService.Create(Self);
    Result.ServiceProc := AServiceProc;
    FServices.AddObject(AServiceName, Result);
  end else
    Result := nil;
end;

procedure TNsmServiceList.Delete(Index: Integer);
begin
  TNsmService(FServices.Objects[Index]).Free;
  FServices.Delete(Index);
end;

procedure TNsmServiceList.Remove(Item: TNsmService);
var
  Idx: Integer;
begin
  Idx := FServices.IndexOfObject(Item);
  if Idx > -1 then
    Delete(Idx);
end;

procedure TNsmServiceList.Clear;
begin
  while FServices.Count > 0 do
    Delete(0);
end;

function TNsmServiceList.IndexOf(ServiceName: String): Integer;
begin
  Result := FServices.IndexOf(ServiceName)
end;

function TNsmServiceList.Find(ServiceName: String): TNsmService;
var
  Idx: Integer;
begin
  Idx := IndexOf(ServiceName);
  if Idx > -1 then
    Result := TNsmService(FServices.Objects[idx])
  else
    Result := nil;
end;

// TNsmThreadServiceList -------------------------------------------------------

constructor TNsmThreadServiceList.Create;
begin
  inherited;
  FServices := TNsmServiceList.Create;
end;

destructor TNsmThreadServiceList.Destroy;
begin
  FServices.Free;
  inherited;
end;

function TNsmThreadServiceList.LockList: TNsmServiceList;
begin
  FCriticalSection.Enter;
  Result := FServices;
end;

procedure TNsmThreadServiceList.UnlockList;
begin
  FCriticalSection.Leave;
end;

// -----------------------------------------------------------------------------

initialization
  FCriticalSection := TCriticalSection.Create;

finalization
  FCriticalSection.Free;

end.
