unit UFrmNsmMain;
(* NSM SYSTEM CEBhE *)

interface

uses
  Windows, Messages, SysUtils, MinApp, APIWindow, UNsmCom, UNsmSystem,
  UNsmPlugin, UNsmConsts;

type
  TFrmNsmMain = class(TMinForm)
  private
    procedure ApplicationIdle(Sender: TObject; var Done: Boolean);
  public
    constructor Create(hParent: HWND); override;
    destructor Destroy; override;
  end;

var
  FrmNsmMain: TFrmNsmMain;

implementation

resourcestring
  RS_ERROR_NOUIMODULE = 'UI W[܂łB'#13#10 +
      'Plugins tH_ UI W[݂邩mFĉB';

// -----------------------------------------------------------------------------

constructor TFrmNsmMain.Create(hParent: HWND);
begin
  inherited;
  Application.OnIdle := ApplicationIdle;
  with NsmSystem do
  begin
    Plugins.Search(ExtractFilePath(Application.ExeName) + 'Plugins\*.dll');
    if Plugins.IndexOfModuleName(NMM_UI) = -1 then
    begin
      MessageBox(Handle, PChar(RS_ERROR_NOUIMODULE), PChar(Application.Title),
          MB_ICONEXCLAMATION);
      Application.Terminate;
      Exit;
    end else
      Initialize;
  end;
end;

destructor TFrmNsmMain.Destroy;
begin
  Application.OnIdle := nil;
  NsmSystem.Terminate;
  Application.Terminate;
  inherited;
end;

procedure TFrmNsmMain.ApplicationIdle(Sender: TObject; var Done: Boolean);
var
  Handle: THandle;
begin
  Done := False;
  Handle := 0;
  MsgWaitForMultipleObjectsEx(
      0, Handle, INFINITE, QS_ALLINPUT, MWMO_ALERTABLE);
end;

end.
