unit UWideUtils;

interface

uses
  StrUtils;

const
  WideNull      = WideChar(#0);
  WideTab       = WideChar(#09);
  WideCR        = WideChar(#13);
  WideLF        = WideChar(#10);
  WideCRLF      = WideString(#13#10);
  WideLS        = WideChar($2028);    // Line Separator
  WidePS        = WideChar($2029);    // Paragraph Separator

type
  TWideStringDynArray  = array of WideString;

function WideStrScan(Str: PWideChar; Chr: WideChar): PWideChar;
function WideStrEnd(const Str: PWideChar): PWideChar;
function WideStrLComp(S1, S2: PWideChar; MaxLen: Cardinal): Integer;
function WideStrLIComp(S1, S2: PWideChar; MaxLen: Cardinal): Integer;

function WideCopy(S: WideString; Index, Count: Integer): WideString;
function WidePos(const Substr, S: WideString; Idx: Integer = 1): Integer;

function WideReplaceStr(const AText, AFromText, AToText: WideString): WideString;
function WideReplaceStrEx(S: WideString; Args: array of WideString): WideString;
function WideReplaceTextEx(S: WideString; Args: array of WideString): WideString;

procedure WideSplit(const S, Delimiter: WideString; var List: TWideStringDynArray; const Count: Integer = 0);

implementation

function WideStrScan(Str: PWideChar; Chr: WideChar): PWideChar;
begin
  Result := Str;
  while Result^ <> WideNull do
  begin
    if Result^ = Chr then Exit;
    Inc(Result);
  end;
  Result := nil;
end;

function WideStrEnd(const Str: PWideChar): PWideChar;
begin
  Result := Str;
  while Result^ <> WideNull do
    Inc(Result);
end;

function WideStrLComp(S1, S2: PWideChar; MaxLen: Cardinal): Integer;
var
  I: Integer;
begin
  Result := 0;
  for I := 0 to MaxLen - 1 do
    if S1[I] <> S2[I] then
    begin
      Result := Cardinal(S1[I]) - Cardinal(S2[I]);
      Break;
    end;
end;

function WideStrLIComp(S1, S2: PWideChar; MaxLen: Cardinal): Integer;
  function SameAlphabet(WC1, WC2: WideChar): Boolean;
  begin
    if Cardinal(WC1) in [$0041..$005A] then
      Inc(WC1, $0020);
    if Cardinal(WC2) in [$0041..$005A] then
      Inc(WC2, $0020);
    Result := (WC1 = WC2);
  end;
var
  I: Integer;
begin
  Result := 0;
  for I := 0 to MaxLen - 1 do
    if (S1[I] <> S2[I]) and not SameAlphabet(S1[I], S2[I]) then
    begin
      Result := Cardinal(S1[I]) - Cardinal(S2[I]);
      Break;
    end;
end;

function WideCopy(S: WideString; Index, Count: Integer): WideString;
var
  SourceLen, CopyLen, EndIdx: Integer;
begin
  SourceLen := Length(S);
  EndIdx := Index + Count - 1;
  if EndIdx > SourceLen then
    EndIdx := SourceLen;
  CopyLen := EndIdx - Index + 1;
  SetLength(Result, CopyLen);
  System.Move(S[Index], Result[1], CopyLen * SizeOf(WideChar));
end;

function WidePos(const Substr, S: WideString; Idx: Integer = 1): Integer;
var
  I, Len, SubLen, EndIdx: Integer;
begin
  Len := Length(S);
  SubLen := Length(Substr);
  EndIdx := Len - SubLen + 1;
  Result := 0;
  for I := Idx to EndIdx do
    if WideStrLComp(@S[I], @Substr[1], SubLen) = 0 then
    begin
      Result := I;
      Break;
    end;
end;

// u
function WideReplaceStr(const AText, AFromText, AToText: WideString): WideString;
var
  I, Len, SubLen, EndIdx: Integer;
begin
  I := 1;
  Len := Length(AText);
  SubLen := Length(AFromText);
  EndIdx := Len - SubLen + 1;
  Result := '';
  while I <= EndIdx do
  begin
    if WideStrLComp(@Atext[I], @AFromText[1], SubLen) = 0 then
    begin
      Result := Result + AToText;
      Inc(I, SubLen);
    end else
    begin
      Result := Result + AText[I];
      Inc(I);
    end;
  end;
  if I < Len then
    Result := Result + WideCopy(AText, I, Len);
end;

// Cɒu
//
// Text := ReplaceStrEx(Text, [From1, To1, From2, To2, From3, To3]);
//
function WideReplaceStrEx(S: WideString; Args: array of WideString): WideString;
var
  I, J, Len: Integer;
  Replaced: Boolean;
begin
  Replaced := False;
  I := 1;
  Len := Length(S);
  Result := '';
  while I <= Len do
  begin
    for J := 0 to (Length(Args) - 1) div 2 do
      if WideStrLComp(@S[I], @Args[J * 2][1], Length(Args[J * 2])) = 0 then
      begin
        Result := Result + Args[J * 2 + 1];
        Inc(I, Length(Args[J * 2]));
        Replaced := True;
        Break;
      end;
    if not Replaced then
    begin
      Result := Result + S[I];
      Inc(I);
    end;
    Replaced := False;
  end;
end;

function WideReplaceTextEx(S: WideString; Args: array of WideString): WideString;
var
  I, J, Len: Integer;
  Replaced: Boolean;
begin
  Replaced := False;
  I := 1;
  Len := Length(S);
  Result := '';
  while I <= Len do
  begin
    for J := 0 to (Length(Args) - 1) div 2 do
      if WideStrLIComp(@S[I], @Args[J * 2][1], Length(Args[J * 2])) = 0 then
      begin
        Result := Result + Args[J * 2 + 1];
        Inc(I, Length(Args[J * 2]));
        Replaced := True;
        Break;
      end;
    if not Replaced then
    begin
      Result := Result + S[I];
      Inc(I);
    end;
    Replaced := False;
  end;
end;

// ؂蕶ŕĔzɊi[
procedure WideSplit(const S, Delimiter: WideString; var List: TWideStringDynArray; const Count: Integer = 0);
var
  I, StartPos, Len, SubLen, EndIdx, ListCount: Integer;
begin
  I := 1;
  StartPos := 1;
  ListCount := 0;
  Len := Length(S);
  SubLen := Length(Delimiter);
  EndIdx := Len - SubLen + 1;
  SetLength(List, 0);
  while (I <= EndIdx) and ((Count = 0) or (ListCount < Count - 1)) do
  begin
    if WideStrLComp(@S[I], @Delimiter[1], SubLen) = 0 then
    begin
      Inc(ListCount);
      SetLength(List, ListCount);
      List[ListCount - 1] := WideCopy(S, StartPos, I - StartPos);
      Inc(I, SubLen);
      StartPos := I;
    end else
    begin
      Inc(I);
    end;
  end;
  if StartPos <= Len then
  begin
    Inc(ListCount);
    SetLength(List, ListCount);
    List[ListCount - 1] := WideCopy(S, StartPos, Len);
  end;
end;

end.
