unit USimpleTimer;

interface

uses
  Windows;

type
  TTimerProc = procedure (hWnd: HWND; uMsg, idEvent: Cardinal; dwTime: DWORD); stdcall;
  TSimpleTimer = class(TObject)
  private
    FInterval: Cardinal;
    FTimerID: Cardinal;
    FActive: Boolean;
    FOnTimer: TTimerProc;
    procedure SetInterval(Value: Cardinal);
    procedure SetActive(Value: Boolean);
  public
    constructor Create;
    destructor Destroy; override;
    property Interval: Cardinal read FInterval write SetInterval;
    property Active: Boolean read FActive write SetActive;
    property OnTimer: TTimerProc read FOnTimer write FOnTimer;
  end;

implementation

constructor TSimpleTimer.Create;
begin
  FActive := False;
  FInterval := 1000;
end;

destructor TSimpleTimer.Destroy;
begin
  SetActive(False);
  inherited;
end;

procedure TSimpleTimer.SetInterval(Value: Cardinal);
begin
  if FInterval <> Value then
  begin
    FInterval := Value;
    if FActive then
    begin
      SetActive(False);
      SetActive(True);
    end;
  end;
end;

procedure TSimpleTimer.SetActive(Value: Boolean);
begin
  if FActive <> Value then
  begin
    FActive := Value and Assigned(FOnTimer);
    if FActive then
      FTimerID := SetTimer(0, 0, FInterval, @FOnTimer)
    else
      KillTimer(0, FTimerID);
  end;
end;

end.
 