unit UCTimeUtils;

interface

uses
  Windows;

type
  CTime = Integer;

function CTimeToDateTime(Time: CTime): TDateTime;
function DateTimeToCTime(Time: TDateTime): CTime;

implementation

var
  TimeZoneInformation: TTimeZoneInformation;
  Bias: TDateTime;

const
  SecondsPerDay = 24 * 60 * 60;

function CTimeToDateTime(Time: CTime): TDateTime;
begin
  Result := Time / SecondsPerDay + Bias;
end;

function DateTimeToCTime(Time: TDateTime): CTime;
begin
  Result := Round((Time - Bias) * SecondsPerDay);
end;

initialization
  GetTimeZoneInformation(TimeZoneInformation);
  Bias := (365 * 70 + 19) - TimeZoneInformation.Bias / (60 * 24);
end.

