unit UUserProfile;

interface

uses
  Classes, SysUtils, IniFiles, UNsmUtils, UNsmConsts;

type
  TUserProfile = class(TObject)
  private
    FProfileName: String;
    FProtocol: String;
    FAccount: String;
    FPassword: String;
    FAutoConnect: Boolean;
    FStatus: Integer;
    FData: Pointer;
  public
    property ProfileName: String read FProfileName write FProfileName;
    property Protocol: String read FProtocol write FProtocol;
    property Account: String read FAccount write FAccount;
    property Password: String read FPassword write FPassword;
    property AutoConnect: Boolean read FAutoConnect write FAutoConnect;
    property Status: Integer read FStatus write FStatus;
    property Data: Pointer read FData write FData;
  end;

  TUserProfiles = class(TObject)
  private
    FItems: TList;
    function GetItem(Index: Integer): TUserProfile;
    function GetCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add: TUserProfile;
    procedure Delete(Idx: Integer);
    procedure Clear;
    procedure Move(CurIndex, NewIndex: Integer);

    procedure SaveToFile(const FileName: String);
    procedure LoadFromFile(const FileName: String);

    property Items[Index: Integer]: TUserProfile read GetItem; default;
    property Count: Integer read GetCount;
  end;

implementation

const
  INISECTION_PROFILE = 'UserProfiles';
  
constructor TUserProfiles.Create;
begin
  FItems := TList.Create;
end;

destructor TUserProfiles.Destroy;
begin
  Clear;
  FItems.Free;
  inherited;
end;

function TUserProfiles.GetItem(Index: Integer): TUserProfile;
begin
  Result := TUserProfile(FItems[Index]);
end;

function TUserProfiles.GetCount: Integer;
begin
  Result := FItems.Count;
end;

// ǉ
function TUserProfiles.Add: TUserProfile;
begin
  Result := TUserProfile.Create;
  FItems.Add(Result);
end;

// 폜
procedure TUserProfiles.Delete(Idx: Integer);
begin
  TUserProfile(FItems[Idx]).Free;
  FItems.Delete(Idx);
end;

// S
procedure TUserProfiles.Clear;
begin
  while FItems.Count > 0 do
    Delete(0);
end;

procedure TUserProfiles.Move(CurIndex, NewIndex: Integer);
begin
  FItems.Move(CurIndex, NewIndex);
end;

procedure TUserProfiles.SaveToFile(const FileName: String);
var
  Ini: TIniFile;
  I: Integer;
  Value: String;
begin
  Randomize;
  Ini := TIniFile.Create(FileName);
  try
    Ini.EraseSection(INISECTION_PROFILE);
    for I := 0 to FItems.Count - 1 do
    begin
      Value := Format('%s %s %s %s %d %d', [
                EncodeSpace(Items[I].ProfileName),
                EncodeSpace(Items[I].Protocol),
                EncodeSpace(Items[I].Account),
                EncodeSpace(EncodePassword(Items[I].Password)),
                Ord(Items[I].AutoConnect), Items[I].Status]);
      Ini.WriteString(INISECTION_PROFILE, IntToStr(I), Value);
    end;
  finally
    Ini.Free;
  end;
end;

procedure TUserProfiles.LoadFromFile(const FileName: String);
var
  Ini: TIniFile;
  I: Integer;
  Value: String;
const
  SprtChar = ' ';
begin
  Ini := TIniFile.Create(FileName);
  try
    I := 0;
    Value := Ini.ReadString(INISECTION_PROFILE, IntToStr(I), '');
    while Length(Value) > 0 do
    begin
      with Add do
      begin
        ProfileName := DecodeSpace(GetNextParam(Value, SprtChar));
        Protocol    := DecodeSpace(GetNextParam(Value, SprtChar));
        Account     := DecodeSpace(GetNextParam(Value, SprtChar));
        Password    := DecodePassword(DecodeSpace(GetNextParam(Value, SprtChar)));
        AutoConnect := Boolean(StrToIntDef(GetNextParam(Value, SprtChar), 0));
        Status      := StrToIntDef(GetNextParam(Value, SprtChar), NMST_ONLINE);
      end;
      Inc(I);
      Value := Ini.ReadString(INISECTION_PROFILE, IntToStr(I), '');
    end;
  finally
    Ini.Free;
  end;
end;

end.
