unit USimpleHint;

interface

uses
  Windows, Controls, Forms, Types, UNsmUtils;

type
  TSimpleHint = class(THintWindow)
    procedure NCPaint(DC: HDC); override;
    procedure Paint; override;
  public
    function CalcHintRect(MaxWidth: Integer; const AHint: string;
      AData: Pointer): TRect; override;
  end;

implementation

function TSimpleHint.CalcHintRect(MaxWidth: Integer; const AHint: string;
  AData: Pointer): TRect;
var
  S: String;
begin
  S := DecodeControlChar(AHint);
  Result := Rect(0, 0, MaxWidth, 0);
  Canvas.Font := Screen.HintFont;  
  DrawText(Canvas.Handle, PChar(S), -1, Result, DT_CALCRECT or DT_LEFT or
    DT_WORDBREAK or DT_NOPREFIX);
  Inc(Result.Right, 10);
  Inc(Result.Bottom, 6);
end;

procedure TSimpleHint.NCPaint(DC: HDC);
var
  R: TRect;
begin
  R := Rect(0, 0, Width, Height);
  DrawEdge(DC, R, BDR_RAISEDOUTER, BF_RECT or BF_MONO);
end;

procedure TSimpleHint.Paint;
var
  S: String;
  R: TRect;
begin
  S := DecodeControlChar(Caption);
  R := ClientRect;
  Inc(R.Left, 4);
  Inc(R.Top, 4);
  Canvas.Font := Screen.HintFont;
  DrawText(Canvas.Handle, PChar(S), -1, R, DT_LEFT or DT_NOPREFIX or
    DT_WORDBREAK);
end;

initialization
  HintWindowClass := TSimpleHint;

finalization
  HintWindowClass := THintWindow;
end.
