unit UFrmProfiles;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, StdCtrls, ExButton, ComCtrls, Menus, ExtCtrls,
  ActnList, ExPanel, ExSpeedButton, UStrResource, UUserProfile, USkinResource,
  USimpleUICore, ResizeArea, UNsmConsts;

type
  TFrmProfiles = class(TFrmBase)
    ListView: TListView;
    btnOK: TExButton;
    btnAdd: TExButton;
    btnDelete: TExButton;
    btnProperty: TExButton;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnPropertyClick(Sender: TObject);
    procedure ListViewDblClick(Sender: TObject);
    procedure ListViewSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure ListViewDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ListViewDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
  private
    procedure UpdateListView;
  protected
    procedure UpdateSkinObjects; override;
  public
    { Public 錾 }
  end;

implementation

uses UFrmEditProfile;

{$R *.dfm}

procedure TFrmProfiles.UpdateSkinObjects;
begin
  inherited;
  ListView.SmallImages := SkinResources.StateImages;
end;

procedure TFrmProfiles.UpdateListView;
var
  I, TopIdx: Integer;
  SelData: Pointer;
  Item: TListItem;
begin
  if Assigned(ListView.Selected) then
    SelData := ListView.Selected.Data
  else
    SelData := nil;
  if Assigned(ListView.TopItem) then
    TopIdx := ListView.TopItem.Index
  else
    TopIdx := 0;
  ListView.Items.BeginUpdate;
  try
    ListView.Clear;
    for I := 0 to SimpleUICore.UserProfiles.Count - 1 do
      with ListView.Items.Add do
      begin
        if (SimpleUICore.UserProfiles.Items[I].Status = NMST_HIDDEN) then
          ImageIndex := 3
        else
          ImageIndex := 0;
        Caption := SimpleUICore.UserProfiles.Items[I].ProfileName;
        SubItems.Add(SimpleUICore.UserProfiles.Items[I].Protocol);
        SubItems.Add(SimpleUICore.UserProfiles.Items[I].Account);
        Data := SimpleUICore.UserProfiles.Items[I];
      end;
    if Assigned(SelData) then
    begin
      Item := ListView.FindData(0, SelData, True, False);
      if Assigned(Item) then
        Item.Selected := True;
    end;
    if TopIdx < ListView.Items.Count then
    begin
      ListView.Items[ListView.Items.Count - 1].MakeVisible(False);
      ListView.Items[TopIdx].MakeVisible(False);      
    end;
  finally
    ListView.Items.EndUpdate;
  end;
end;

procedure TFrmProfiles.FormCreate(Sender: TObject);
begin
  inherited;
  Caption := RS_FORM_PROFILETITLE;
  Sizeable := False;
end;

procedure TFrmProfiles.FormShow(Sender: TObject);
begin
  inherited;
  UpdateListView;
end;

procedure TFrmProfiles.btnAddClick(Sender: TObject);
var
  Form: TFrmEditProfile;
begin
  inherited;
  Form := TFrmEditProfile.CreateAsDialog(Self);
  try
    if Form.ShowModal = mrOk then
    begin
      with SimpleUICore.UserProfiles.Add do
      begin
        ProfileName := Form.ProfileName;
        Account     := Form.Account;
        Password    := Form.Password;
        Protocol    := Form.Protocol;
        AutoConnect := Form.AutoConnect;
        Status      := Form.Status;
      end;
      UpdateListView;
    end;
  finally
    Form.Release;
  end;
end;

procedure TFrmProfiles.btnDeleteClick(Sender: TObject);
var
  Idx: Integer;
begin
  inherited;
  Idx := ListView.ItemIndex;
  if Idx > -1 then
    if MessageBox(Handle,
      PChar('"' + SimpleUICore.UserProfiles[Idx].ProfileName +
      '" 폜Ă낵łH'), PChar(RS_FORM_PROFILETITLE),
      MB_OKCANCEL or MB_ICONQUESTION) = ID_OK then
    begin
      SimpleUICore.UserProfiles.Delete(Idx);
      UpdateListView;
    end;
end;

procedure TFrmProfiles.btnPropertyClick(Sender: TObject);
var
  Idx: Integer;
  Form: TFrmEditProfile;
begin
  inherited;
  Idx := ListView.ItemIndex;
  if Idx = -1 then Exit;
  Form := TFrmEditProfile.CreateAsDialog(Self);
  try
    with Form do
    begin
      ProfileName := SimpleUICore.UserProfiles[Idx].ProfileName;
      Account     := SimpleUICore.UserProfiles[Idx].Account;
      Password    := SimpleUICore.UserProfiles[Idx].Password;
      Protocol    := SimpleUICore.UserProfiles[Idx].Protocol;
      AutoConnect := SimpleUICore.UserProfiles[Idx].AutoConnect;
      Status      := SimpleUICore.UserProfiles[Idx].Status;
    end;
    if Form.ShowModal = mrOk then
    begin
      with SimpleUICore.UserProfiles[Idx] do
      begin
        ProfileName := Form.ProfileName;
        Account     := Form.Account;
        Password    := Form.Password;
        Protocol    := Form.Protocol;
        AutoConnect := Form.AutoConnect;
        Status      := Form.Status;
      end;
      UpdateListView;
    end;
  finally
    Form.Release;
  end;
end;

procedure TFrmProfiles.ListViewDblClick(Sender: TObject);
begin
  inherited;
  btnPropertyClick(btnProperty);
end;

procedure TFrmProfiles.ListViewSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
begin
  inherited;
  btnDelete.Enabled := Assigned(ListView.Selected);
  btnProperty.Enabled := Assigned(ListView.Selected);
end;

procedure TFrmProfiles.ListViewDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Target: TListItem;
begin
  inherited;
  if Assigned(ListView.Selected) then
  begin
    Target := ListView.GetItemAt(X, Y);
    if Assigned(Target) and (Target <> ListView.Selected) then
    begin
      SimpleUICore.UserProfiles.Move(ListView.Selected.Index, Target.Index);
      UpdateListView;
    end;
  end;
end;

procedure TFrmProfiles.ListViewDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  inherited;
  Accept := True;
end;

end.
