unit UFrmOption;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UStrResource, UFrmBase, Menus, ExtCtrls, ActnList, ExPanel,
  ExSpeedButton, StdCtrls, ComCtrls, ExButton, UConfig, UNotify,
  USimpleUICore, ResizeArea, ImgList, USkinResource, uOpenSaveDialogEx,
  UNsmUIPluginMainEx;

type
  TFrmOption = class(TFrmBase)
    btnOk: TExButton;
    btnCancel: TExButton;
    pnlPageBack: TExPanel;
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    pnlPageTitle: TPanel;
    TreeView: TTreeView;
    cbShowHint: TCheckBox;
    TabSheet3: TTabSheet;
    memMsgHead: TMemo;
    lblMsgHead: TLabel;
    Label1: TLabel;
    sbInsertTag: TExSpeedButton;
    pmTag: TPopupMenu;
    NAME1: TMenuItem;
    ACCOUNT1: TMenuItem;
    HOUR1: TMenuItem;
    MINUTE1: TMenuItem;
    SECOND1: TMenuItem;
    N1: TMenuItem;
    DAY1: TMenuItem;
    MONTH1: TMenuItem;
    YEAR1: TMenuItem;
    NOW1: TMenuItem;
    DATE1: TMenuItem;
    IME1: TMenuItem;
    N2: TMenuItem;
    TabSheet4: TTabSheet;
    GroupBox2: TGroupBox;
    rbSortByName: TRadioButton;
    rbSortByStatus: TRadioButton;
    rbSortByAccount: TRadioButton;
    GroupBox3: TGroupBox;
    cbUseTaskTray: TCheckBox;
    TabSheet5: TTabSheet;
    GroupBox1: TGroupBox;
    lblSnapSize: TLabel;
    cbSnapToScreenEdge: TCheckBox;
    cbSnapToWindowEdge: TCheckBox;
    edtSnapSize: TEdit;
    udSnapSize: TUpDown;
    Label3: TLabel;
    TabSheet2: TTabSheet;
    lvNotifyList: TListView;
    pmNotify: TPopupMenu;
    mnuNotifyProperty: TMenuItem;
    mnuNotifyPlaySound: TMenuItem;
    TabSheet6: TTabSheet;
    GroupBox5: TGroupBox;
    cbDoubleBuffered: TCheckBox;
    GroupBox6: TGroupBox;
    cbUseWindowShade: TCheckBox;
    GroupBox7: TGroupBox;
    cbHideEmptyGroup: TCheckBox;
    cbHideOffline: TCheckBox;
    TabSheet7: TTabSheet;
    GroupBox8: TGroupBox;
    lblNotifyTime: TLabel;
    lblNotifyTime2: TLabel;
    edtNotifyTime: TEdit;
    udNotifyTime: TUpDown;
    GroupBox9: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    udMainTransparency: TUpDown;
    Label6: TLabel;
    Label7: TLabel;
    Edit2: TEdit;
    udChatTransparency: TUpDown;
    Label8: TLabel;
    Label9: TLabel;
    Edit3: TEdit;
    udNotifyTransparency: TUpDown;
    GroupBox4: TGroupBox;
    lblMaxTabLength: TLabel;
    Label2: TLabel;
    edtMaxTabLength: TEdit;
    udMaxTabLength: TUpDown;
    lblMsgHead2: TLabel;
    sbInsertTag2: TExSpeedButton;
    memMsgHead2: TMemo;
    TabSheet8: TTabSheet;
    GroupBox10: TGroupBox;
    edtDefaultBrowser: TEdit;
    cbDefaultBrowser: TCheckBox;
    btnDefaultBrowser: TExButton;
    OpenDialog: TOpenDialogEx;
    edt2chBrowser: TEdit;
    cb2chBrowser: TCheckBox;
    btn2chBrowser: TExButton;
    cbHideBlocked: TCheckBox;
    tsPlugin: TTabSheet;
    lvPluginList: TListView;
    Panel1: TPanel;
    lblPluginInfo1: TLabel;
    Label10: TLabel;
    edtPlugInfo2: TEdit;
    edtPlugInfo1: TEdit;
    btnPluginOption: TExButton;
    memPlugInfo3: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure PageControlDrawTab(Control: TCustomTabControl;
      TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure PageControlChange(Sender: TObject);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure cbShowHintClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure sbInsertTagClick(Sender: TObject);
    procedure NAME1Click(Sender: TObject);
    procedure lvNotifyListData(Sender: TObject; Item: TListItem);
    procedure lvNotifyListDblClick(Sender: TObject);
    procedure mnuNotifyPropertyClick(Sender: TObject);
    procedure mnuNotifyPlaySoundClick(Sender: TObject);
    procedure pmNotifyPopup(Sender: TObject);
    procedure btnDefaultBrowserClick(Sender: TObject);
    procedure cbDefaultBrowserClick(Sender: TObject);
    procedure cb2chBrowserClick(Sender: TObject);
    procedure lvPluginListData(Sender: TObject; Item: TListItem);
    procedure lvPluginListSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure btnPluginOptionClick(Sender: TObject);
  protected
    procedure UpdateSkinObjects; override;
  private
    FNotifyList: TEventNotifyList;
    procedure UpdateTreeView;
  public
    procedure ApplyConfig; override;
    procedure UpdateConfig; override;
  end;

implementation

uses UFrmEditNotify, UNsmConsts, UNsmUtils, UNsmTypes;

{$R *.dfm}

procedure TFrmOption.ApplyConfig;
begin
  inherited;
  ShowHint := cbShowHint.Checked;  
  cbSnapToScreenEdge.Checked := Config.SnapToScreenEdge;
  cbSnapToWindowEdge.Checked := Config.SnapToWindowEdge;
  cbDoubleBuffered.Checked := Config.DoubleBuffered;
  cbUseTaskTray.Checked := Config.UseTaskTray;
  cbShowHint.Checked := Config.OptionShowHint;
  udSnapSize.Position := Config.SnapSize;
  memMsgHead.Text := Config.MsgHead;
  memMsgHead2.Text := Config.MsgHead2;  
  cbHideOffline.Checked := Config.HideOffline;
  cbHideBlocked.Checked := Config.HideBlocked;
  cbHideEmptyGroup.Checked := Config.HideEmptyGroup;
  rbSortByName.Checked := (Config.SortKey = skName);
  rbSortByStatus.Checked := (Config.SortKey = skStatus);
  rbSortByAccount.Checked := (Config.SortKey = skAccount);
  udMaxTabLength.Position := Config.MaxTabLength;
  cbUseWindowShade.Checked := Config.UseWindowShade;
  udNotifyTime.Position := Config.NotifyTime;
  udMainTransparency.Position := Config.MainTransparency;
  udChatTransparency.Position := Config.ChatTransparency;
  udNotifyTransparency.Position := Config.NotifyTransparency;
  cbDefaultBrowser.Checked := (Length(Config.PathDefaultBrowser) > 0);
  edtDefaultBrowser.Text := Config.PathDefaultBrowser;
  cb2chBrowser.Checked := (Length(Config.Path2chBrowser) > 0);
  edt2chBrowser.Text := Config.Path2chBrowser;

  FNotifyList.Assign(SimpleUICore.NotifyItems);
  lvNotifyList.Items.Count := FNotifyList.Count;
  
  cbDefaultBrowserClick(cbDefaultBrowser);
  cb2chBrowserClick(cb2chBrowser);
end;

procedure TFrmOption.UpdateSkinObjects;
begin
  inherited;
  lvNotifyList.SmallImages := SkinResources.MenuImages;
  lvNotifyList.StateImages := SkinResources.MenuImages;
  lvPluginList.SmallImages := SkinResources.MenuImages;
end;

procedure TFrmOption.UpdateConfig;
begin
  inherited;
  if ModalResult = mrOk then
  begin
    Config.OptionShowHint := cbShowHint.Checked;
    Config.SnapToScreenEdge := cbSnapToScreenEdge.Checked;
    Config.SnapToWindowEdge := cbSnapToWindowEdge.Checked;
    Config.DoubleBuffered := cbDoubleBuffered.Checked;
    Config.SnapSize := udSnapSize.Position;
    Config.UseTaskTray := cbUseTaskTray.Checked;
    Config.MsgHead := memMsgHead.Text;
    Config.MsgHead2 := memMsgHead2.Text;
    Config.HideOffline := cbHideOffline.Checked;
    Config.HideBlocked := cbHideBlocked.Checked;
    Config.HideEmptyGroup := cbHideEmptyGroup.Checked;
    if rbSortByName.Checked then
      Config.SortKey := skName
    else if rbSortByStatus.Checked then
      Config.SortKey := skStatus
    else if rbSortByAccount.Checked then
      Config.SortKey := skAccount;
    Config.MaxTabLength := udMaxTabLength.Position;
    Config.UseWindowShade := cbUseWindowShade.Checked;
    Config.NotifyTime := udNotifyTime.Position;
    Config.MainTransparency := udMainTransparency.Position;
    Config.ChatTransparency := udChatTransparency.Position;
    Config.NotifyTransparency := udNotifyTransparency.Position;
    if cbDefaultBrowser.Checked then
      Config.PathDefaultBrowser := edtDefaultBrowser.Text
    else
      Config.PathDefaultBrowser := '';
    if cb2chBrowser.Checked then
      Config.Path2chBrowser := edt2chBrowser.Text
    else
      Config.Path2chBrowser := '';

    SimpleUICore.NotifyItems.Assign(FNotifyList);
  end;
end;

procedure TFrmOption.UpdateTreeView;
var
  I: Integer;
  Node: TTreeNode;
begin
  Node := nil;
  for I := 0 to PageControl.PageCount - 1 do
    if PageControl.Pages[I].Tag > 0 then
      with TreeView.Items.AddChild(Node, PageControl.Pages[I].Caption) do
      begin
        ImageIndex := PageControl.Pages[I].ImageIndex;
        SelectedIndex := PageControl.Pages[I].ImageIndex;
      end
    else
    begin
      Node := TreeView.Items.Add(nil, PageControl.Pages[I].Caption);
      Node.ImageIndex := PageControl.Pages[I].ImageIndex;
      Node.SelectedIndex := PageControl.Pages[I].ImageIndex;
    end;
  TreeView.FullExpand;
end;

procedure TFrmOption.FormCreate(Sender: TObject);
begin
  FNotifyList := TEventNotifyList.Create;
  inherited;
  Caption := RS_FORM_OPTIONTITLE;
  Sizeable := False;
  UpdateTreeView;
  PageControl.ActivePageIndex := 0;
  with pnlPageTitle do
  begin
    Parent := PageControl;
    SetBounds(0, 0, PageControl.ClientWidth, PageControl.TabHeight);
  end;

  lvPluginList.Items.Count := SimpleUICore.Modules.Count;

  PageControlChange(PageControl);
  cbShowHintClick(cbShowHint);
end;

procedure TFrmOption.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  Action := caFree;
end;

procedure TFrmOption.FormDestroy(Sender: TObject);
begin
  inherited;
  FNotifyList.Free;
end;

procedure TFrmOption.PageControlDrawTab(Control: TCustomTabControl;
  TabIndex: Integer; const Rect: TRect; Active: Boolean);
var
  R: TRect;
begin
  inherited;
  R := Rect;
  if TabIndex = PageControl.ActivePageIndex then
    Inc(R.Top, 2);
  Control.Canvas.FillRect(R);
  DrawText(Control.Canvas.Handle, PChar(PageControl.Pages[TabIndex].Caption),
      -1, R, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
end;

procedure TFrmOption.PageControlChange(Sender: TObject);
begin
  inherited;
  pnlPageTitle.Caption := PageControl.ActivePage.Caption;
  TreeView.Selected := TreeView.Items[PageControl.ActivePageIndex];
end;

procedure TFrmOption.TreeViewChange(Sender: TObject; Node: TTreeNode);
begin
  inherited;
  if TreeView.Selected <> nil then
    PageControl.ActivePageIndex := TreeView.Selected.AbsoluteIndex;
  pnlPageTitle.Caption := GetLongHint(PageControl.ActivePage.Hint);
end;

procedure TFrmOption.cbShowHintClick(Sender: TObject);
begin
  inherited;
  ShowHint := cbShowHint.Checked;
end;

procedure TFrmOption.btnOkClick(Sender: TObject);
var
  I: Integer;
begin
  inherited;
  UpdateConfig;

  // SẴEBhEɐݒKp
  for I := 0 to Screen.FormCount - 1 do
    if Screen.Forms[I].InheritsFrom(TFrmBase) and
      (Screen.Forms[I] <> Self) then
      TFrmBase(Screen.Forms[I]).ApplyConfig;
end;

procedure TFrmOption.sbInsertTagClick(Sender: TObject);
var
  P: TPoint;
begin
  inherited;
  P := TControl(Sender).ClientToScreen(Point(0, TControl(Sender).Height));
  pmTag.Popup(P.X, P.Y);
end;

procedure TFrmOption.NAME1Click(Sender: TObject);
begin
  inherited;
  if memMsgHead.Focused then
    memMsgHead.SelText := TMenuItem(Sender).Caption
  else if memMsgHead2.Focused then
    memMsgHead2.SelText := TMenuItem(Sender).Caption;
end;

procedure TFrmOption.lvNotifyListData(Sender: TObject; Item: TListItem);
begin
  inherited;
  case TEventNotifyType(Item.Index) of
    ntExclamation       : Item.Caption := 'x';
    ntStop              : Item.Caption := 'G[';
    ntInformation       : Item.Caption := '';
    ntQuestion          : Item.Caption := '₢킹';
    ntReceiveMessage    : Item.Caption := 'bZ[WM';
    ntReceiveMail       : Item.Caption := '[M';
    ntReceiveFile       : Item.Caption := 't@CM';
    ntConnect           : Item.Caption := 'ڑ';
    ntDisconnect        : Item.Caption := 'ؒf';
    ntMemberOnline      : Item.Caption := 'oIC';
    ntMemberOffline     : Item.Caption := 'oItC';
    ntSendMessage       : Item.Caption := 'bZ[WM';
    ntFinishFileSend    : Item.Caption := 't@CM';
    ntFinishFileReceive : Item.Caption := 't@CM';
  end;
  if FNotifyList[TEventNotifyType(Item.Index)].NotifyEnabled then
    Item.StateIndex := MENUICON_NOTIFY
  else
    Item.StateIndex := -1;
  if FNotifyList[TEventNotifyType(Item.Index)].SoundEnabled then
    Item.ImageIndex := MENUICON_SOUND
  else
    Item.ImageIndex := -1;
  Item.SubItems.Add(
    ExtractFileName(FNotifyList[TEventNotifyType(Item.Index)].SoundFileName));
end;

procedure TFrmOption.lvNotifyListDblClick(Sender: TObject);
begin
  inherited;
  mnuNotifyPropertyClick(mnuNotifyProperty)
end;

procedure TFrmOption.mnuNotifyPropertyClick(Sender: TObject);
begin
  inherited;
  if Assigned(lvNotifyList.Selected) then
  begin
    with TFrmEditNotify.CreateAsDialog(Self) do
    begin
      SetNotify(FNotifyList[TEventNotifyType(lvNotifyList.ItemIndex)]);
      ShowModal;
      Release;
    end;
    lvNotifyList.Invalidate;
  end;
end;

procedure TFrmOption.mnuNotifyPlaySoundClick(Sender: TObject);
begin
  inherited;
  if Assigned(lvNotifyList.Selected) then
    FNotifyList[TEventNotifyType(lvNotifyList.ItemIndex)].PlaySound(True);
end;

procedure TFrmOption.pmNotifyPopup(Sender: TObject);
begin
  inherited;
  mnuNotifyProperty.Enabled := Assigned(lvNotifyList.Selected);
  mnuNotifyPlaySound.Enabled := Assigned(lvNotifyList.Selected);
end;

procedure TFrmOption.btnDefaultBrowserClick(Sender: TObject);
begin
  inherited;
  if OpenDialog.Execute then
    if Sender = btnDefaultBrowser then
      edtDefaultBrowser.Text := OpenDialog.FileName
    else if Sender = btn2chBrowser then
      edt2chBrowser.Text := OpenDialog.FileName;
end;

procedure TFrmOption.cbDefaultBrowserClick(Sender: TObject);
begin
  inherited;
  edtDefaultBrowser.Enabled := cbDefaultBrowser.Checked;
  btnDefaultBrowser.Enabled := cbDefaultBrowser.Checked;
  if edtDefaultBrowser.Enabled then
    edtDefaultBrowser.Color := clWindow
  else
    edtDefaultBrowser.ParentColor := True;
end;

procedure TFrmOption.cb2chBrowserClick(Sender: TObject);
begin
  inherited;
  edt2chBrowser.Enabled := cb2chBrowser.Checked;
  btn2chBrowser.Enabled := cb2chBrowser.Checked;
  if edt2chBrowser.Enabled then
    edt2chBrowser.Color := clWindow
  else
    edt2chBrowser.ParentColor := True;
end;

procedure TFrmOption.lvPluginListData(Sender: TObject; Item: TListItem);
var
  ModuleName: String;
begin
  inherited;
  ModuleName := SimpleUICore.Modules[Item.Index];
  Item.Caption := SimpleUICore.GetInfo.GetPluginInfo(ModuleName, NMPI_TITLE);
  Item.SubItems.Add(SimpleUICore.GetInfo.GetPluginInfo(ModuleName, NMPI_PLUGINVER));
  Item.SubItems.Add(ExtractModuleType(ModuleName));
  Item.ImageIndex := MENUICON_PLUGIN;
end;

procedure TFrmOption.lvPluginListSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
var
  ModuleName: String;
begin
  inherited;
  if Assigned(Item) then
  begin
    ModuleName := SimpleUICore.Modules[Item.Index];
    edtPlugInfo1.Text := SimpleUICore.GetInfo.GetPluginInfo(ModuleName, NMPI_AUTHOR);
    edtPlugInfo2.Text := SimpleUICore.GetInfo.GetPluginInfo(ModuleName, NMPI_COPYRIGHT);
    memPlugInfo3.Text := SimpleUICore.GetInfo.GetPluginInfo(ModuleName, NMPI_DESCRIPTION);
    memPlugInfo3.Perform(WM_VSCROLL, MakeLong(SB_TOP, 0), 0);
    btnPluginOption.Visible :=
        (SimpleUICore.GetService(Format(NMS_COMMON_SHOWOPTIONDIALOG, [ModuleName])) <> 0);
  end else
  begin
    edtPlugInfo1.Text := '';
    edtPlugInfo2.Text := '';
    memPlugInfo3.Text := '';
    btnPluginOption.Visible := False;
  end;
end;

procedure TFrmOption.btnPluginOptionClick(Sender: TObject);
var
  HService: HNsmService;
  ModuleName: String;
begin
  inherited;
  if Assigned(lvPluginList.Selected) then
  begin
    ModuleName := SimpleUICore.Modules[lvPluginList.Selected.Index];
    if ModuleName = NMM_UI then
    begin
      MessageBox(Handle, 'AAJĂ邵BB', PChar(ModuleName), MB_ICONEXCLAMATION);
      Exit;
    end;
    HService := SimpleUICore.GetService(Format(NMS_COMMON_SHOWOPTIONDIALOG, [ModuleName]));
    if HService <> 0 then
      SimpleUICore.CallService(HService, Handle, 0)
    else
      MessageBox(Handle, '̃vOCɂ͐ݒ荀ڂ܂B', PChar(ModuleName), MB_ICONEXCLAMATION);
  end;
end;

end.
