unit UFrmHistory;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmWebBrowser, Menus, ExtCtrls, ActnList, ExPanel, ExSpeedButton,
  StdCtrls, UStrResource, USimpleUICore, UNsmUtils, UConfig, DateUtils,
  UWideUtils, ResizeArea, UNsmUIPluginMainEx;

type
  TFrmHistory = class(TFrmWebBrowser)
    pnlMemberInfo: TExPanel;
    lblMemberInfo: TLabel;
    pnlWebBrowser: TExPanel;
    procedure FormCreate(Sender: TObject);
    procedure pnlBackResize(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    function MakeMsgBody(const Msg, Style: WideString): WideString;
  public
    procedure ApplyConfig; override;
    procedure LoadHistory(const LogFileName: String);
    procedure SetMemberInfo(Member: TNsmUIMember);
  end;

function ShowHistory(Member: TNsmUIMember): Boolean;

implementation

{$R *.dfm}

// Ot@C݂Η\
function ShowHistory(Member: TNsmUIMember): Boolean;
var
  GLFNI: TGetLogFileNameInfo;
  Buff: array[0..1024] of Char;
begin
  if Member.Owner.Owner is TNsmUIConnection then
  begin
    GLFNI.lpProtocol := PChar(TNsmUIConnection(Member.Owner.Owner).Protocol);
    GLFNI.lpUserAccount := PChar(TNsmUIConnection(Member.Owner.Owner).UserAccount);
  end else
  if Member.Owner.Owner is TNsmUISession then
  begin
    GLFNI.lpProtocol := PChar(TNsmUISession(Member.Owner.Owner).Protocol);
    GLFNI.lpUserAccount := PChar(TNsmUISession(Member.Owner.Owner).Connection.UserAccount);
  end;
  with GLFNI do
  begin
    lpAccount := PChar(Member.Account);
    lpLogName := Buff;
    nBuffSize := SizeOf(Buff);
  end;
  SimpleUICore.CallService(
      NMS_SIMPLELOG_GETLOGFILENAME, Cardinal(@GLFNI), 0);
  Result := FileExists(Buff);
  if Result then
    with TFrmHistory.Create(nil) do
    begin
      LoadHistory(Buff);
      SetMemberInfo(Member);
      Show;
    end;
end;

// -----------------------------------------------------------------------------

procedure TFrmHistory.ApplyConfig;
begin
  inherited;
  MsgHead := Config.MsgHead2;
end;

procedure TFrmHistory.LoadHistory(const LogFileName: String);
var
  Log, Line, Account, Name, Msg, Style: WideString;
  Date: TDateTime;
begin
  Screen.Cursor := crHourGlass;
  try
    Log := LoadStringFromFileW(LogFileName);
    Line := GetNextParamW(Log, WideCRLF);
    while (Length(Line) > 0) and  (Length(Log) > 0) do
    begin
      Account := GetNextParamW(Line, WideTab);
      Name    := GetNextParamW(Line, WideTab);
      Date    := StrToFloatDef(GetNextParamW(Line, WideTab), 0);
      Style   := GetNextParamW(Line, WideTab);
      Msg     := DecodeControlChar(GetNextParamW(Line, WideTab));
      OutputMessage(MakeMsgHeader(Name, Account, Date),
                    MakeMsgBody(Msg, Style), clNone, False);
      Line := GetNextParamW(Log, WideCRLF);
    end;
  finally
    Screen.Cursor := crDefault;
  end;    
end;

procedure TFrmHistory.SetMemberInfo(Member: TNsmUIMember);
begin
  Caption := RS_FORM_HISTORYTITILE + ' - ' + Member.Name;
  lblMemberInfo.Caption := Format('%s <%s>', [Member.Name, Member.Account]);
end;

function TFrmHistory.MakeMsgBody(const Msg, Style: WideString): WideString;
begin
  Result := '<FONT STYLE ="' + Style + '">' + PreProcessMsg(Msg) + '</FONT>';
end;

procedure TFrmHistory.FormCreate(Sender: TObject);
begin
  WebBrowserParent := pnlWebBrowser;
  inherited;
  Caption := RS_FORM_HISTORYTITILE;
end;

procedure TFrmHistory.pnlBackResize(Sender: TObject);
begin
  inherited;
  AdjustWebBrowserBounds;
end;

procedure TFrmHistory.FormShow(Sender: TObject);
begin
  inherited;
  AdjustWebBrowserBounds;
end;

end.
