unit UFrmColor;
(* Copyright (C) 2001-2002 Yamaneko <ymnk160@hotmail.com> *)
(* NSM FI_CAO *)

interface

uses
  Windows, Messages, Graphics, Controls, Forms, Classes;

const
  GRIDSIZE = 14;
  LEVEL = 4;
  COLCOUNT = 8;
  ROWCOUNT = 15;

type
  TSelectColorEvent = procedure (Sender: TObject; AColor: TColor) of object;
  TFrmColor = class(TForm)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDeactivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ON_WM_ACTIVATEAPP(var Msg: TWMActivateApp ); message WM_ACTIVATEAPP;
  private
    FOnSelect: TSelectColorEvent;
    FSelected: TColor;
    ColorTable: array[0..256] of TColor;
    OldCell: TPoint;
    function GetIndexColor(Idx: Integer): TColor;
    procedure DrawSelRect(Col, Row: Integer; Selected: Boolean);
  protected
    procedure CreateParams(var Params: TCreateParams);override;    
  public
    property Selected: TColor read FSelected write FSelected;
    property OnSelect: TSelectColorEvent read FOnSelect write FOnSelect;
  end;

implementation

{$R *.dfm}

procedure TFrmColor.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or WS_BORDER;
  Params.ExStyle := Params.ExStyle or WS_EX_TOOLWINDOW;
end;

procedure TFrmColor.ON_WM_ACTIVATEAPP(var Msg: TWMActivateApp);
begin
  inherited;
  if Active then
    Activate
  else
    Deactivate;
end;

procedure TFrmColor.DrawSelRect(Col, Row: Integer; Selected: Boolean);
begin
  with Canvas do
  if Selected then
  begin
    Brush.Color := clWhite;
    FrameRect((Rect(Col * GRIDSIZE + 1, Row * GRIDSIZE + 1,
              Col * GRIDSIZE + GRIDSIZE - 1, Row * GRIDSIZE + GRIDSIZE - 1)));
    Brush.Color := clBlack;
    FrameRect((Rect(Col * GRIDSIZE, Row * GRIDSIZE,
              Col * GRIDSIZE + GRIDSIZE, Row * GRIDSIZE + GRIDSIZE)));
  end else
  begin
    Brush.Color := GetIndexColor(COLCOUNT * Row + Col);
    FrameRect((Rect(Col * GRIDSIZE + 1, Row * GRIDSIZE + 1,
              Col * GRIDSIZE + GRIDSIZE - 1, Row * GRIDSIZE + GRIDSIZE - 1)));
    Brush.Color := clWhite;
    FrameRect((Rect(Col * GRIDSIZE, Row * GRIDSIZE,
              Col * GRIDSIZE + GRIDSIZE, Row * GRIDSIZE + GRIDSIZE)));
    if (GetIndexColor(COLCOUNT * Row + Col) = clWhite) then
    begin
      Brush.Color := clSilver;
      FrameRect(Rect(Col * GRIDSIZE + 1, Row * GRIDSIZE + 1,
                Col * GRIDSIZE + GRIDSIZE - 1, Row * GRIDSIZE + GRIDSIZE - 1));
    end;
  end;
end;

procedure TFrmColor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmColor.FormDeactivate(Sender: TObject);
begin
  Close;
end;

function TFrmColor.GetIndexColor(Idx: Integer): TColor;
begin
  if (Idx >= 0) and (Idx < Length(ColorTable)) then
    Result := ColorTable[Idx]
  else
    Result := clBlack;
end;

procedure TFrmColor.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  Cursor := crHandPoint;
  ClientWidth := COLCOUNT * GRIDSIZE;
  ClientHeight := ROWCOUNT * GRIDSIZE;
  OldCell.X := -1;
  OldCell.Y := -1;

  ColorTable[0] := clBlack;
  ColorTable[1] := clMaroon;
  ColorTable[2] := clGreen;
  ColorTable[3] := clOlive;
  ColorTable[4] := clNavy;
  ColorTable[5] := clPurple;
  ColorTable[6] := clTeal;
  ColorTable[7] := clGray;
  ColorTable[8] := clSilver;
  ColorTable[9] := clRed;
  ColorTable[10] := clLime;
  ColorTable[11] := clYellow;
  ColorTable[12] := clBlue;
  ColorTable[13] := clFuchsia;
  ColorTable[14] := clAqua;
  ColorTable[15] := clWhite;

  // O[XP[
  for I := 1 to LEVEL * 2 do
    ColorTable[15 + LEVEL * 0 + I] := RGB(Trunc(I / LEVEL / 2 * 230), Trunc(I / LEVEL / 2 * 230), Trunc(I / LEVEL / 2 * 230));

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 2 + I] := RGB(Trunc(I / LEVEL * 255), 0, 0);
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 3 + I] := RGB(255, Trunc(I / LEVEL * 230), Trunc(I / LEVEL * 230));

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 4 + I] := RGB(Trunc(I / LEVEL * 255), Trunc(I / LEVEL * 128), 0);
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 5 + I] := RGB(255, Trunc(128 + (I / LEVEL * 230) / 2), Trunc(I / LEVEL * 230));

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 6 + I] := RGB(Trunc(I / LEVEL * 255), Trunc(I / LEVEL * 255), 0);
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 7 + I] := RGB(255, 255, Trunc(I / LEVEL * 230));

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 8 + I] := RGB(Trunc(I / LEVEL * 128), Trunc(I / LEVEL * 255), 0);
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 9 + I] := RGB(Trunc(128 + (I / LEVEL * 230) / 2), 255, Trunc(I / LEVEL * 230));

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 10 + I] := RGB(0, Trunc(I / LEVEL * 255), 0);
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 11 + I] := RGB(Trunc(I / LEVEL * 230), 255, Trunc(I / LEVEL * 230));

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 12 + I] := RGB(0, Trunc(I / LEVEL * 255), 128);
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 13 + I] := RGB(Trunc(I / LEVEL * 230), 255, Trunc(128 + (I / LEVEL * 230) / 2));

  // F
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 14 + I] := RGB(0, Trunc(I / LEVEL * 255), Trunc(I / LEVEL * 255));
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 15 + I] := RGB(Trunc(I / LEVEL * 230), 255, 255);

  // F
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 16 + I] := RGB(0, Trunc(I / LEVEL * 128), Trunc(I / LEVEL * 255));
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 17 + I] := RGB(Trunc(I / LEVEL * 230), Trunc(128 + (I / LEVEL * 230) / 2), 255);

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 18 + I] := RGB(0, 0, Trunc(I / LEVEL * 255));
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 19 + I] := RGB(Trunc(I / LEVEL * 230), Trunc(I / LEVEL * 230), 255);

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 20 + I] := RGB(Trunc(I / LEVEL * 128), 0, Trunc(I / LEVEL * 255));
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 21 + I] := RGB(Trunc(128 + (I / LEVEL * 230) / 2), Trunc(I / LEVEL * 230), 255);

  // 
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 22 + I] := RGB(Trunc(I / LEVEL * 255), 0, Trunc(I / LEVEL * 255));
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 23 + I] := RGB(255, Trunc(I / LEVEL * 230), 255);

  // Ԏ
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 24 + I] := RGB(Trunc(I / LEVEL * 255), 0, Trunc(I / LEVEL * 128));
  for I := 1 to LEVEL do
    ColorTable[15 + LEVEL * 25 + I] := RGB(255, Trunc(I / LEVEL * 230), Trunc(128 + (I / LEVEL * 230) / 2));
end;

procedure TFrmColor.FormPaint(Sender: TObject);
var
  X, Y: Integer;
  CurColor: TColor;
begin

  with Canvas do
  begin
    Brush.Color := clWhite;
    FillRect(ClientRect);
    for Y := 0 to ROWCOUNT do
      for X := 0 to COLCOUNT do
      begin
        CurColor := GetIndexColor(COLCOUNT * Y + X);
        Brush.Color := CurColor;
        FillRect(Rect(X * GRIDSIZE + 1, Y * GRIDSIZE + 1,
                      X * GRIDSIZE + GRIDSIZE - 1, Y * GRIDSIZE + GRIDSIZE - 1));
        if (CurColor = clWhite) then
        begin
          Brush.Color := clSilver;
          FrameRect(Rect(X * GRIDSIZE + 1, Y * GRIDSIZE + 1,
                    X * GRIDSIZE + GRIDSIZE - 1, Y * GRIDSIZE + GRIDSIZE - 1));
        end;

        if (CurColor = FSelected) and ((OldCell.X = -1) or (OldCell.Y = -1)) then
        begin
          DrawSelRect(X, Y, True);
          OldCell.X := X;
          OldCell.Y := Y;
        end;
      end;
  end;
end;

procedure TFrmColor.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  X := Trunc(X / GRIDSIZE);
  Y := Trunc(Y / GRIDSIZE);

  if (OldCell.X <> X) or (OldCell.Y <> Y) then
    with Canvas do
    begin
      DrawSelRect(OldCell.X, OldCell.Y, False);
      DrawSelRect(X, Y, True);
      OldCell.X := X;
      OldCell.Y := Y;
    end;
end;

procedure TFrmColor.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FSelected := GetIndexColor(COLCOUNT * (Y div GRIDSIZE) + (X div GRIDSIZE));
  if @FOnSelect <> nil then
    FOnSelect(Self, FSelected);
  Close;
end;

end.
