unit UFrmBaseClient;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFrmBase, Menus, ExtCtrls, ActnList, ExPanel, ExSpeedButton,
  StdCtrls, UFrmBaseContainer, (*ExLabel,*) ResizeArea;

type
  TFrmBaseClient = class(TFrmBase)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FContainer: TFrmBaseContainer;
    procedure SysMenuClick(Sender: TObject);
    procedure SetContainer(Value: TFrmBaseContainer);
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure SetCaption(Value: WideString); override;
    procedure UpdateSystemMenu; override;
    procedure DockToContainer; virtual;
    procedure Flash(Invert: Boolean); override;
  public
    procedure Blink(Count: Integer); override;
    procedure ShowDocked;
    property Container: TFrmBaseContainer read FContainer write SetContainer;
  end;

implementation

{$R *.dfm}

const
  IDM_SYSMENU1 = $0000;
  IDM_SYSMENU2 = $0001;

procedure TFrmBaseClient.SetCaption(Value: WideString);
begin
  inherited;
  if Assigned(Parent) and Assigned(FContainer) and
     FContainer.ContainsDockWindow(Self) then
  begin
    FContainer.UpdateCaption;
    FContainer.UpdateTabCaption(Self);
  end;
end;

procedure TFrmBaseClient.SetContainer(Value: TFrmBaseContainer);
begin
  FContainer := Value;
  if Assigned(FContainer) then
    FContainer.FreeNotification(Self);
end;

procedure TFrmBaseClient.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  if (AComponent = FContainer) and (Operation = opRemove) then
    FContainer := nil;
end;

procedure TFrmBaseClient.UpdateSystemMenu;
begin
  inherited;
  DeleteSystemMenu(IDM_SYSMENU1);
  DeleteSystemMenu(IDM_SYSMENU2);
  AddSystemMenu('-', IDM_SYSMENU1, nil);
  AddSystemMenu('ReiɊi[(&D)', IDM_SYSMENU2, SysMenuClick);
end;

procedure TFrmBaseClient.Blink(Count: Integer);
begin
  inherited;
  if Assigned(Parent) and Assigned(FContainer) and
     FContainer.ContainsDockWindow(Self) then
  begin
    FContainer.Blink(Count);
  end;
end;

procedure TFrmBaseClient.Flash(Invert: Boolean);
begin
  inherited;
  if Assigned(Parent) and Assigned(FContainer) and
     FContainer.ContainsDockWindow(Self) then
  begin
    FContainer.FlashTab(Self, Invert);
  end;
end;

// eReiɃhbLO
procedure TFrmBaseClient.DockToContainer;
begin
  if not Assigned(Parent) and Assigned(FContainer) and
     not FContainer.ContainsDockWindow(Self) then
    FContainer.DockWindow(Self);
end;

procedure TFrmBaseClient.SysMenuClick(Sender: TObject);
begin
  inherited;
  DockToContainer;
end;

procedure TFrmBaseClient.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  inherited;
  if Assigned(Parent) and Assigned(FContainer) and
     FContainer.ContainsDockWindow(Self) then
    FContainer.RemoveTab(Self);
end;

// hbLOĂꍇ̓ReiŃANeBuɂ
procedure TFrmBaseClient.ShowDocked;
begin
  if Assigned(Parent) and Assigned(FContainer) and
     FContainer.ContainsDockWindow(Self) then
  begin
     FContainer.ActiveDockedForm := Self;
     FContainer.Show;
  end else
    inherited Show;
end;

end.
