unit UFrmBase;

interface

uses
  Windows, Messages, Graphics, Forms, ActnList, Classes, Controls, ExtCtrls,
  StdCtrls, USkinResource, ExSpeedButton, ComCtrls, ExButton, ExTabSet, Menus,
  ExPanel, ExScrollBar, UConfig, SysUtils, UWideGraphics, ResizeArea,
  USkinStyles;

const
  DefaultTitleHeight = 20;
  DefaultBorderWidth = 5;
  DefaultButtonHeight = 15;
  DefaultButtonWidth = 15;
  DefaultScrollBarWidth = 16;
  
type
  TSysMenuItem = record
    CommandID: Cardinal;
    OnClick: TNotifyEvent;
  end;

  TWindowStyle = record
    ActiveStyle: TSkinStyle;
    InactiveStyle: TSkinStyle;
  end;
  TSysButtonStyle = record
    UpStyle: TWindowStyle;
    DownStyle: TWindowStyle;
    HotStyle: TWindowStyle;
  end;
  TButtonStyle = record
    UpStyle: TSkinStyle;
    DownStyle: TSkinStyle;
  end;
  TScrollBarStyle = record
    Style: TSkinStyle;
    ThumbStyle: TButtonStyle;
    UpButtonStyle: TButtonStyle;
    DownButtonStyle: TButtonStyle;
  end;

  TFrmBase = class(TForm)
    pnlBack: TExPanel;
    ActionList: TActionList;
    actFormClose: TAction;
    sbClose: TExSpeedButton;
    sbMax: TExSpeedButton;
    sbMin: TExSpeedButton;
    actFormMaximize: TAction;
    actFormMinimize: TAction;
    actFormRestore: TAction;
    sbRestore: TExSpeedButton;
    ResizeGrip: TResizeArea;
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure actFormCloseExecute(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDblClick(Sender: TObject);
    procedure actFormMaximizeExecute(Sender: TObject);
    procedure actFormMinimizeExecute(Sender: TObject);
    procedure actFormRestoreExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    FCaption: WideString;
    FShaded: Boolean;
    FActiveSkinPainted: Boolean;
    FNormalHeight: Integer;
    FExBorder: Boolean;
    FSizeable: Boolean;
    FDialog: Boolean;
    FStayOnTop: Boolean;
    FWindowFit: Boolean;
    FWindowKind: TWindowKind;
    FWindowStyle: TWindowStyle;
    FCaptionStyle: TWindowStyle;
    FCloseButtonStyle: TSysButtonStyle;
    FMaxButtonStyle: TSysButtonStyle;
    FMinButtonStyle: TSysButtonStyle;
    FRestoreButtonStyle: TSysButtonStyle;
    FResizeGripStyle: TWindowStyle;
    FButtonStyle: TButtonStyle;
    FMenuBarStyle: TSkinStyle;
    FScrollBarStyle: TScrollBarStyle;
    FClientBorderStyle: TSkinBorderStyle;
    FFlashTimer: TTimer;
    FFlashCount: Integer;
    FFlashInvert: Boolean;
    FSysMenuItems: array of TSysMenuItem;
    function GetCaption: WideString;
    procedure ApplyStyle;
    procedure ApplyControlSize;
    procedure ApplyRegion;
    procedure DrawCaption;
    procedure SetWindowKind(Value: TWindowKind);
    function GetWindowStyle: TSkinStyle;
    function GetCaptionStyle: TSkinStyle;
    procedure SetExBorder(Value: Boolean);
    procedure SetSizeable(Value: Boolean);
    procedure SetShaded(Value: Boolean);
    procedure SetStayOnTop(Value: Boolean);
    function GetCanResize: Boolean;
    function GetParentForm: TCustomForm;
    function GetParentFormActive: Boolean;
    function GetDesktopRect: TRect;
    function GetNormalWindowRect: TRect;
    procedure FlashTimerProc(Sender: TObject);
    procedure ON_WM_SYSCOMMAND(var Msg: TWMSysCommand); message WM_SYSCOMMAND;
//    procedure ON_WM_NCHITTEST(var Msg: TWMNCHitTest); message WM_NCHITTEST;
    procedure ON_WM_WINDOWPOSCHANGING(var Msg : TWMWindowPosChanging); message WM_WINDOWPOSCHANGING;
    procedure ON_WM_ACTIVATE(var Msg: TWMActivate); message WM_ACTIVATE;
    procedure ON_WM_ACTIVATEAPP(var Msg: TWMActivateApp ); message WM_ACTIVATEAPP;
    procedure ON_WM_GETMINMAXINFO(var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
  protected
    procedure ApplyBorderStyle; virtual;
    procedure SetCaption(Value: WideString); virtual;
    procedure CreateParams(var Params: TCreateParams);override;
    procedure UpdateSkinObjects; virtual;
    procedure SetParent(AParent: TWinControl); override;
    procedure UpdateSystemMenu; virtual;
    procedure AddSystemMenu(Caption: String; CommandID: Cardinal; OnClick: TNotifyEvent);
    procedure DeleteSystemMenu(CommandID: Cardinal);
    procedure Flash(Invert: Boolean); virtual;
  public
    constructor Create(AOwner: TComponent); override;
    constructor CreateAsDialog(AOwner: TComponent);
    procedure UpdateActions; override;    
    function ShowModal: Integer; override;
    procedure Blink(Count: Integer); virtual;
    procedure StopBlink;
    procedure LoadSkinResource; virtual;
    procedure ApplySkinResource;
    procedure ApplyConfig; virtual;
    procedure ApplyPrivateConfig; virtual;
    procedure UpdateConfig; virtual;
    property Caption: WideString read GetCaption write SetCaption;
    property ExBorder: Boolean read FExBorder write SetExBorder;
    property Sizeable: Boolean read FSizeable write SetSizeable;
    property Shaded: Boolean read FShaded write SetShaded;
    property StayOnTop: Boolean read FStayOnTop write SetStayOnTop;
    property WindowFit: Boolean read FWindowFit write FWindowFit;
    property WindowStyle: TSkinStyle read GetWindowStyle;
    property CaptionStyle: TSkinStyle read GetCaptionStyle;
    property WindowKind: TWindowKind read FWindowKind write SetWindowKind;
    property NormalWindowRect: TRect read GetNormalWindowRect;
    property ParentForm: TCustomForm read GetParentForm;
    property ParentFormActive: Boolean read GetParentFormActive;
  end;

implementation

{$R *.dfm}

// Bitmap 烊[W쐬
function CreateRgnFromBitmap(Src: TBitmap; TransparentColor: TColor): HRGN;
var
  Stream: TMemoryStream;
var
  Bitmap: TBitmap;
  pLine: PWORD;
  x, y, StartPos: Integer;
  R: TRect;
begin
  Result := HRGN(0);
  Bitmap := TBitmap.Create;
  try
    // ̃rbg}bv畡ă}XN܂
    Bitmap.Assign(Src);
    if not Bitmap.Empty then
    begin
      Stream := TMemoryStream.Create;
      try
        Stream.SetSize(sizeof(TRGNDATAHEADER));
        with PRgnDataHeader(Stream.Memory)^ do
        begin
          dwSize := sizeof(TRGNDATAHEADER);
          iType := RDH_RECTANGLES;
          nCount := 0;
          nRgnSize := 0;
          rcBound := RECT(0, 0, Bitmap.Width, Bitmap.Height);
        end;
        Stream.Position := sizeof(TRGNDATAHEADER);

        // }XNimNjɂ܂
        Bitmap.Mask(TransparentColor);

        // ScanLine f[^₷悤 2bytes/pixel ɂ܂
        Bitmap.PixelFormat := pf15bit;

        for y := 0 to Bitmap.Height - 1 do
        begin
          pLine := Bitmap.ScanLine[y];
          StartPos := -1;
          for x := 0 to Bitmap.Width - 1 do
          begin
            if(StartPos < 0)and(pLine^ = 0)then
              StartPos := x;
            if(StartPos >= 0)then
            begin
              if(pLine^ <> 0)then
              begin
                R.Left := StartPos;
                R.Right := x;
                R.Top := y;
                R.Bottom := R.Top + 1;

                Stream.Write(R, sizeof(TRect));
                Inc(PRgnDataHeader(Stream.Memory)^.nCount);

                StartPos := -1;
              end
              else if x = (Bitmap.Width - 1)then
              begin
                R.Left := StartPos;
                R.Right := x + 1;
                R.Top := y;
                R.Bottom := R.Top + 1;

                // RECT ނтɃXg[̃TCY
                // ŝŁA̕AIł Delphi4 ł
                // pXs[hłiԂ Delphi3 łvj
                Stream.Write(R, sizeof(TRect));
                Inc(PRgnDataHeader(Stream.Memory)^.nCount);

                StartPos := -1;
              end;
            end;
            Inc(pLine);
          end;
        end; // for y := ...
        Result := ExtCreateRegion(nil, Stream.Size, 
                                  PRgnData(Stream.Memory)^);
        if Result = 0 then
          Result := CreateRectRgn(0, 0, Bitmap.Width, Bitmap.Height);
      finally
        Stream.Free;
      end;
    end;
  finally
    Bitmap.Free;
  end;
end;


// -----------------------------------------------------------------------------

procedure TFrmBase.ApplyConfig;
begin
  // DoubleBuffered
  DoubleBuffered := Config.DoubleBuffered;
  pnlBack.DoubleBuffered := Config.DoubleBuffered;
end;

procedure TFrmBase.ApplyPrivateConfig;
begin
  //
end;

procedure TFrmBase.UpdateConfig;
begin
  //
end;

procedure TFrmBase.SetCaption(Value: WideString);
begin
  if Value <> GetCaption then
  begin
    FCaption := Value;
    inherited Caption := FCaption;
//    SetWindowText(Handle, PChar(String(Value)));
    Invalidate;
  end;
end;

function TFrmBase.GetCaption: WideString;
begin
  Result := FCaption;
end;

procedure TFrmBase.SetParent(AParent: TWinControl);
begin
  inherited;
  if not Application.Terminated and (ControlCount > 0) then
    ApplyBorderStyle;
end;

procedure TFrmBase.ApplyStyle;
  procedure ApplySysButtonStyle(Style: TSysButtonStyle; Btn: TExSpeedButton);
  begin
    if Active = not FFlashInvert then
    begin
      Btn.UpStyle := Style.UpStyle.ActiveStyle;
      Btn.DownStyle := Style.DownStyle.ActiveStyle;
      Btn.HotStyle := Style.HotStyle.ActiveStyle;
    end else
    begin
      Btn.UpStyle := Style.UpStyle.InactiveStyle;
      Btn.DownStyle := Style.DownStyle.InactiveStyle;
      Btn.HotStyle := Style.HotStyle.InactiveStyle;
    end;
    Btn.UpStyle.SetControlBounds(Btn, Btn.Left, Btn.Top, DefaultButtonWidth, DefaultButtonHeight);    
  end;
begin
  Icon.Assign(SkinResources.WindowIcons[FWindowKind]);
  Color := WindowStyle.BackgroundColor;
  Font.Color := WindowStyle.FontColor;
  ApplySysButtonStyle(FCloseButtonStyle, sbClose);
  ApplySysButtonStyle(FMaxButtonStyle, sbMax);
  ApplySysButtonStyle(FMinButtonStyle, sbMin);
  ApplySysButtonStyle(FRestoreButtonStyle, sbRestore);
  if Active = not FFlashInvert then
    ResizeGrip.Style := FResizeGripStyle.ActiveStyle
  else
    ResizeGrip.Style := FResizeGripStyle.InactiveStyle;
  Invalidate;
end;

procedure TFrmBase.ApplyControlSize;
var
  TitleHeight, SideWidth, BottomHeight: Integer;
begin
  if not WindowStyle.TopImage.Empty then
    TitleHeight := WindowStyle.TopImage.Height
  else
    TitleHeight := DefaultTitleHeight;
  if not WindowStyle.LeftImage.Empty then
    SideWidth := WindowStyle.LeftImage.Width
  else
    SideWidth := DefaultBorderWidth;
  if not WindowStyle.BottomImage.Empty then
    BottomHeight := WindowStyle.BottomImage.Height
  else
    BottomHeight := DefaultBorderWidth;
  if FExBorder then
  begin
    pnlBack.SetBounds(SideWidth, TitleHeight, ClientWidth - SideWidth * 2,
        ClientHeight - BottomHeight - TitleHeight);
    Self.Constraints.MinWidth := 100;
    Self.Constraints.MinHeight := TitleHeight;
  end else
  begin
    pnlBack.SetBounds(0, 0, ClientWidth, ClientHeight);
    Self.Constraints.MinWidth := 0;
    Self.Constraints.MinHeight := 0;
  end;

  ResizeGrip.Style.SetControlSize(ResizeGrip, 16, 16);
  ResizeGrip.Left := ClientWidth - ResizeGrip.Width;
  ResizeGrip.Top := ClientHeight - ResizeGrip.Height;
end;

procedure TFrmBase.ApplyRegion;
var
  Bmp: TBitmap;
  Hrgn1, Hrgn2: HRGN;
begin
  if (WindowStyle.TransparentColor = clNone) or not FExBorder then
  begin
    SetWindowRgn(Handle, HRGN(0), True);
    Exit;
  end;
  Bmp := TBitmap.Create;
  try
    Bmp.Width := ClientWidth;
    if not WindowStyle.TopLeftImage.Empty then
      Bmp.Height := WindowStyle.TopLeftImage.Height
    else
      Bmp.Height := DefaultTitleHeight;
    WindowStyle.Draw(Bmp.Canvas, ClientRect);
    Hrgn1 := CreateRgnFromBitmap(Bmp, clFuchsia);
    if (Integer(Hrgn1) <> 0) then
    begin
      Hrgn2 := CreateRectRgn(0, Bmp.Height, ClientWidth, ClientHeight);
      CombineRgn(Hrgn1, Hrgn1, Hrgn2, RGN_OR);
      SetWindowRgn(Handle, Hrgn1, True);
      DeleteObject(Hrgn2);
    end;
  finally
    Bmp.Free;
  end;
end;

procedure TFrmBase.ApplyBorderStyle;
begin
  if (Parent = nil) and not (WindowStyle.BorderStyle = sbSystem) then
  begin
    BorderStyle := bsNone;
    SetExBorder(True);
    pnlBack.BorderStyle := FClientBorderStyle;
    pnlBack.Transparent := False;
  end else
  if not (Parent = nil) then
  begin
    BorderStyle := bsNone;
    SetExBorder(False);
    pnlBack.BorderStyle := sbNone;
    pnlBack.Transparent := True;
  end else
  begin
    if FSizeable then
      BorderStyle := bsSizeable
    else
      BorderStyle := bsDialog;
    SetExBorder(False);
    pnlBack.BorderStyle := FClientBorderStyle;
    pnlBack.Transparent := False;
  end;
  ResizeGrip.Visible := GetCanResize;
  UpdateSystemMenu;
end;

function TFrmBase.GetWindowStyle: TSkinStyle;
begin
  if Active = not FFlashInvert then
    Result := FWindowStyle.ActiveStyle
  else
    Result := FWindowStyle.InactiveStyle;
end;

function TFrmBase.GetCaptionStyle: TSkinStyle;
begin
  if Active = not FFlashInvert then
    Result := FCaptionStyle.ActiveStyle
  else
    Result := FCaptionStyle.InactiveStyle;
end;

procedure TFrmBase.SetWindowKind(Value: TWindowKind);
begin
  if Value <> FWindowKind then
  begin
    FWindowKind := Value;
    LoadSkinResource;
    ApplySkinResource;
  end;
end;

procedure TFrmBase.SetExBorder(Value: Boolean);
begin
  if FExBorder <> Value then
  begin
    FExBorder := Value;
    ApplyControlSize;
    ApplyRegion;
  end;
end;

procedure TFrmBase.SetSizeable(Value: Boolean);
begin
  if Value <> FSizeable then
  begin
    FSizeable := Value;
    ResizeGrip.Visible := GetCanResize;
    if FSizeable then
      BorderIcons := [biSystemMenu, biMinimize, biMaximize]
    else
      BorderIcons := [];
    ApplyBorderStyle;
  end;
end;

procedure TFrmBase.SetShaded(Value: Boolean);
begin
  if (WindowState <> wsNormal) or Assigned(Parent) then Exit;
  if Value <> FShaded then
  begin
    FShaded := Value;
    if not FShaded then
    begin
      Height := FNormalHeight;
      ResizeGrip.Visible := GetCanResize;
    end else
    begin
      ResizeGrip.Visible := GetCanResize;
      FNormalHeight := Height;
      Height := Constraints.MinHeight;
    end;
  end;
end;

procedure TFrmBase.SetStayOnTop(Value: Boolean);
var
  Flags: Cardinal;
begin
  FStayOnTop := Value;
  if not Visible then Exit;
  Flags := SWP_NOMOVE or SWP_NOSIZE;
  if FStayOnTop then
    SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, Flags)
  else
    SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, Flags);
end;

function TFrmBase.GetCanResize: Boolean;
begin
  Result := FSizeable and (WindowState = wsNormal) and
    not Assigned(Parent) and not FShaded;
end;

function TFrmBase.GetParentForm: TCustomForm;
begin
  if Assigned(Parent) then
    Result := Forms.GetParentForm(Self)
  else
    Result := Self;
end;

function TFrmBase.GetParentFormActive: Boolean;
begin
  Result := ParentForm.Active;
end;

procedure TFrmBase.LoadSkinResource;
  procedure LoadSysButtonStyle(var SysBtnStyle: TSysButtonStyle; ClassName: String);
  begin
    SysBtnStyle.UpStyle.ActiveStyle :=
        SkinResources.GetWindowElementStyle(WindowKind, ssActive, seButton, ClassName, ssUp);
    SysBtnStyle.UpStyle.InactiveStyle :=
        SkinResources.GetWindowElementStyle(WindowKind, ssInactive, seButton, ClassName, ssUp);
    SysBtnStyle.DownStyle.ActiveStyle :=
        SkinResources.GetWindowElementStyle(WindowKind, ssActive, seButton, ClassName, ssDown);
    SysBtnStyle.DownStyle.InactiveStyle :=
        SkinResources.GetWindowElementStyle(WindowKind, ssInactive, seButton, ClassName, ssDown);
    SysBtnStyle.HotStyle.ActiveStyle :=
        SkinResources.GetWindowElementStyle(WindowKind, ssActive, seButton, ClassName, ssHot);
    SysBtnStyle.HotStyle.InactiveStyle :=
        SkinResources.GetWindowElementStyle(WindowKind, ssInactive, seButton, ClassName, ssHot);
  end;
begin
  FWindowStyle.ActiveStyle :=
      SkinResources.GetWindowStyle(FWindowKind, ssActive);
  FWindowStyle.InactiveStyle :=
      SkinResources.GetWindowStyle(FWindowKind, ssInactive);
  FCaptionStyle.ActiveStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seCaption);
  FCaptionStyle.InactiveStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssInactive, seCaption);
  FResizeGripStyle.ActiveStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seResizeGrip);
  FResizeGripStyle.InactiveStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssInactive, seResizeGrip);

  LoadSysButtonStyle(FCloseButtonStyle, 'Close');
  LoadSysButtonStyle(FMaxButtonStyle, 'Max');
  LoadSysButtonStyle(FMinButtonStyle, 'Min');
  LoadSysButtonStyle(FRestoreButtonStyle, 'Restore');


  FButtonStyle.UpStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seButton, '', ssUp);
  FButtonStyle.DownStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seButton, '', ssDown);
  FMenuBarStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seMenuBar);
  FScrollBarStyle.Style :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seScrollBar);
  FScrollBarStyle.ThumbStyle.UpStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seScrollThumb, '', ssUp);
  FScrollBarStyle.ThumbStyle.DownStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seScrollThumb, '', ssDown);
  FScrollBarStyle.UpButtonStyle.UpStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seScrollUpButton, '', ssUp);
  FScrollBarStyle.UpButtonStyle.DownStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seScrollUpButton, '', ssDown);
  FScrollBarStyle.DownButtonStyle.UpStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seScrollDownButton, '', ssUp);
  FScrollBarStyle.DownButtonStyle.DownStyle :=
      SkinResources.GetWindowElementStyle(WindowKind, ssActive, seScrollDownButton, '', ssDown);

  pnlBack.Style := SkinResources.GetWindowElementStyle(WindowKind, ssActive, seClientArea);
  FClientBorderStyle := pnlBack.Style.BorderStyle;
end;

procedure TFrmBase.ApplySkinResource;
begin
  ApplyStyle;
  ApplyBorderStyle;
  ApplyControlSize;
  ApplyRegion;
  Invalidate;
  UpdateSkinObjects;
end;

procedure TFrmBase.UpdateSkinObjects;
var
  I: Integer;
begin
  for I := 0 to ComponentCount - 1 do
  begin
    if Components[I] is TCoolBar then
    begin
      TCoolBar(Components[I]).Color := FMenuBarStyle.BackgroundColor;
      TCoolBar(Components[I]).Font.Color := FMenuBarStyle.FontColor;
      TCoolBar(Components[I]).Bitmap := FMenuBarStyle.BackgroundImage;
    end else
    if Components[I] is TExButton then
    begin
      TExButton(Components[I]).UpStyle := FButtonStyle.UpStyle;
      TExButton(Components[I]).DownStyle := FButtonStyle.DownStyle;
    end else
    if Components[I] is TExScrollBar then
    begin
      TExScrollBar(Components[I]).Style := FScrollBarStyle.Style;
      TExScrollBar(Components[I]).Style.SetControlSize(TExScrollBar(Components[I]), DefaultScrollBarWidth, -1);
      TExScrollBar(Components[I]).ThumbUpStyle := FScrollBarStyle.ThumbStyle.UpStyle;
      TExScrollBar(Components[I]).ThumbDownStyle := FScrollBarStyle.ThumbStyle.DownStyle;
      TExScrollBar(Components[I]).UpButtonUpStyle := FScrollBarStyle.UpButtonStyle.UpStyle;
      TExScrollBar(Components[I]).UpButtonDownStyle := FScrollBarStyle.UpButtonStyle.DownStyle;
      TExScrollBar(Components[I]).DownButtonUpStyle := FScrollBarStyle.DownButtonStyle.UpStyle;
      TExScrollBar(Components[I]).DownButtonDownStyle := FScrollBarStyle.DownButtonStyle.DownStyle
    end;
  end;
end;

procedure TFrmBase.DrawCaption;
var
  R: TRect;
begin
  R := ClientRect;
  if WindowStyle.TopImage.Empty then
    R.Bottom := DefaultTitleHeight
  else
    R.Bottom := WindowStyle.TopImage.Height;
  CaptionStyle.DrawText(Canvas, R, FCaption);
end;

procedure TFrmBase.UpdateSystemMenu;
begin
  //
end;

procedure TFrmBase.AddSystemMenu(Caption: String; CommandID: Cardinal;
  OnClick: TNotifyEvent);
var
  hSysMenu : hMenu;
  NewLen: Integer;
begin
  hSysMenu := GetSystemMenu(Handle, False);

  if Caption = '-' then
    AppendMenu(hSysMenu, MF_SEPARATOR, CommandID, nil)
  else
    AppendMenu(hSysMenu, MF_STRING, CommandID, PChar(Caption));
    
  NewLen := Length(FSysMenuItems) + 1;
  SetLength(FSysMenuItems, NewLen);
  FSysMenuItems[NewLen - 1].CommandID := CommandID;
  FSysMenuItems[NewLen - 1].OnClick := OnClick;
end;

procedure TFrmBase.DeleteSystemMenu(CommandID: Cardinal);
var
  hMen : hMenu;
  I: Integer;
begin
  hMen := GetSystemMenu(Handle, False);
  DeleteMenu(hMen, CommandID, MF_BYCOMMAND);
  for I := 0 to Length(FSysMenuItems) - 1 do
    if FSysMenuItems[I].CommandID = CommandID then
    begin
      Move(FSysMenuItems[I + 1], FSysMenuItems[I],
          (Length(FSysMenuItems) - I) * SizeOf(TSysMenuItem));
      SetLength(FSysMenuItems, Length(FSysMenuItems) - 1);
      Break;
    end;
end;

procedure TFrmBase.ON_WM_SYSCOMMAND(var Msg : TWMSysCommand);
var
  I: Integer;
begin
  inherited;
  for I := 0 to Length(FSysMenuItems) - 1 do
  	if Cardinal(Msg.CmdType) = FSysMenuItems[I].CommandID then
    begin
      if Assigned(FSysMenuItems[I].OnClick) then
        FSysMenuItems[I].OnClick(Self);
      Break;
    end;
end;

{
procedure TFrmBase.ON_WM_NCHITTEST(var Msg: TWMNCHitTest);
const
  Range = 5;
var
  P: TPoint;
  L, T, B, R: Boolean;
begin
  inherited;
  if (not FSizeable) or (not FExBorder) or (WindowState <> wsNormal) then
    Exit;

  GetCursorPos(P);
  L := P.X < Range;
  T := P.Y < Range;
  R := P.X > Width - Range;
  B := P.Y > Height - Range;

  if (L and T) then Msg.Result := HTTOPLEFT
  else if (L and B) then Msg.Result := HTBOTTOMLEFT
  else if (R and T) then Msg.Result := HTTOPRIGHT
  else if (R and B) then Msg.Result := HTBOTTOMRIGHT
  else if (L) then Msg.Result := HTLEFT
  else if (T) then Msg.Result := HTTOP
  else if (R) then Msg.Result := HTRIGHT
  else if (B) then Msg.Result := HTBOTTOM;
end;
}
procedure TFrmBase.ON_WM_WINDOWPOSCHANGING(var Msg : TWMWindowPosChanging);
  function SnapGrid(Pos1, Pos2: Integer): Boolean;
  begin
    Result := (Pos1 >= Pos2 - Config.SnapSize) and
              (Pos1 <= Pos2 + Config.SnapSize);
  end;
var
  Desktop : TRect;
  I: Integer;
  Form: TForm;
begin
  Inherited;
  // TCYύX͏Ȃ
  if (Msg.WindowPos.cx <> Width) or (Msg.WindowPos.cy <> Height) or
     not FWindowFit then Exit;

  Desktop := GetDesktopRect;
  // fXNgbv̒[ɋz
  if Config.SnapToScreenEdge then
  begin
    if SnapGrid(Msg.WindowPos.x, Desktop.Left) then
      Msg.WindowPos.x := Desktop.Left
    else if SnapGrid(Msg.WindowPos.x + Width, Desktop.Right) then
      Msg.WindowPos.x := Desktop.Right - Width;

    if SnapGrid(Msg.WindowPos.y, Desktop.Top) then
      Msg.WindowPos.y := Desktop.Top
    else if SnapGrid(Msg.WindowPos.y + Height, Desktop.Bottom) then
      Msg.WindowPos.y := Desktop.Bottom - Height;
  end;

  // \ĂtH[̒[ɋz
  if Config.SnapToWindowEdge then
    for I := 0 to Screen.FormCount - 1 do
    begin
      Form := Screen.Forms[I];
      // ghbLOĂtH[͖
      if (Form = Self) or Assigned(Form.Parent) or not Form.Visible then
        Continue;
      if SnapGrid(Msg.WindowPos.x, Form.Left + Form.Width) then
        Msg.WindowPos.x := Form.Left + Form.Width
      else if SnapGrid(Msg.WindowPos.x + Width, Form.Left + Form.Width) then
        Msg.WindowPos.x := Form.Left + Form.Width - Width
      else if SnapGrid(Msg.WindowPos.x, Form.Left) then
        Msg.WindowPos.x := Form.Left
      else if SnapGrid(Msg.WindowPos.x + Width, Form.Left) then
        Msg.WindowPos.x := Form.Left - Width;

      if SnapGrid(Msg.WindowPos.y, Form.Top + Form.Height) then
        Msg.WindowPos.y := Form.Top + Form.Height
      else if SnapGrid(Msg.WindowPos.y + Height, Form.Top + Form.Height) then
        Msg.WindowPos.y := Form.Top + Form.Height - Height
      else if SnapGrid(Msg.WindowPos.y, Form.Top) then
        Msg.WindowPos.y := Form.Top
      else if SnapGrid(Msg.WindowPos.y + Height, Form.Top) then
        Msg.WindowPos.y := Form.Top - Height;
    end;
end;

procedure TFrmBase.ON_WM_ACTIVATE(var Msg: TWMActivate);
begin
  inherited;
  if FActiveSkinPainted <> Active then
    ApplyStyle;
  FActiveSkinPainted := Active;
  if Active then
  begin
    StopBlink;
    Activate;
  end else
    Deactivate;
end;

procedure TFrmBase.ON_WM_ACTIVATEAPP(var Msg: TWMActivateApp );
begin
  inherited;
  if FActiveSkinPainted <> Active then
    ApplyStyle;
  FActiveSkinPainted := Active;
  if Active then
  begin
    StopBlink;
    Activate;
  end else
    Deactivate;
end;

procedure TFrmBase.ON_WM_GETMINMAXINFO(var Msg: TWMGetMinMaxInfo);
var
  Desktop: TRect;
begin
  inherited;
  if not FExBorder then Exit;

  Desktop := GetDesktopRect;
  with Msg.MinMaxInfo^ do
  begin
    //ő剻̈ʒu
    with ptMaxPosition do
    begin
      x := Desktop.Left;
      y := Desktop.Top;
    end;
    //ő剻̃TCY
    with ptMaxSize do
    begin
      x := Desktop.Right - Desktop.Left;
      y := Desktop.Bottom - Desktop.Top;
    end;
  end;
end;

constructor TFrmBase.Create(AOwner: TComponent);
begin
  FDialog := False;
  FSizeable := True;
  inherited Create(AOwner);
end;

constructor TFrmBase.CreateAsDialog(AOwner: TComponent);
begin
  FDialog := True;
  FSizeable := False;  
//  FormStyle := fsStayOnTop;
  inherited Create(AOwner);
end;

procedure TFrmBase.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  // Owned Window ɂȂƃ_CAO̕\肭Ȃ
  if FDialog and Assigned(Owner) and (Owner is TCustomForm) then
    Params.WndParent := TCustomForm(Owner).Handle;
  if FSizeable then
    Params.Style := Params.Style or WS_MINIMIZEBOX or WS_MAXIMIZEBOX;
  Params.Style := Params.Style or WS_SYSMENU;
  if FStayOnTop then
    Params.ExStyle := Params.ExStyle or WS_EX_TOPMOST;
end;

// ^Cgo[w񐔓_ł
procedure TFrmBase.Blink(Count: Integer);
var
  fw: FLASHWINFO;
begin
  if Active and not Assigned(Parent) then Exit;
  // ^Cgo[_ł
  with fw do
  begin
    cbSize := SizeOf(FLASHWINFO);
    hwnd := Handle;
    dwFlags := FLASHW_ALL;
    dwTimeout := 500;
    uCount := Count;
  end;
  FlashWindowEx(fw);
  // JX^_ŏ
  FFlashCount := Count * 2;
  if not Assigned(FFlashTimer) then
    FFlashTimer := TTimer.Create(Self);
  with FFlashTimer do
  begin
    Interval := 500;
    Enabled := True;
    OnTimer := FlashTimerProc;
  end;
  Flash(True);
end;

// _ł~߂
procedure TFrmBase.StopBlink;
var
  fw: FLASHWINFO;
begin
  // ^Cgo[_ł
  with fw do
  begin
    cbSize := SizeOf(FLASHWINFO);
    hwnd := Handle;
    dwFlags := FLASHW_STOP;
    dwTimeout := 0;
    uCount := 0;
  end;
  FlashWindowEx(fw);
  Flash(False);
  if Assigned(FFlashTimer) then
    FreeAndNil(FFlashTimer);
end;

// _ŏԂ̐؂ւ
procedure TFrmBase.Flash(Invert: Boolean);
begin
  if ExBorder then
  begin
    if Invert then
      FFlashInvert := not FFlashInvert
    else
      FFlashInvert := False;
    ApplyStyle;
  end;
end;

procedure TFrmBase.FlashTimerProc(Sender: TObject);
begin
  Dec(FFlashCount);
  if FFlashCount <= 0 then
  begin
//    Flash(False);
    FreeAndNil(FFlashTimer);
  end else
  begin
    Flash(True);
  end;
end;

function TFrmBase.ShowModal: Integer;
var
  X, Y: Integer;
  DesktopRect: TRect;
begin
  DesktopRect := GetDesktopRect;
  if Assigned(Owner) and (Owner is TCustomForm) then
  begin
    X := TCustomForm(Owner).Left + (TCustomForm(Owner).Width - Width) div 2;
    Y := TCustomForm(Owner).Top + (TCustomForm(Owner).Height - Height) div 2;
  end else
  begin
    X := (Screen.Width - Width) div 2;
    Y := (Screen.Height - Height) div 2;
  end;

  if (X + Width) > DesktopRect.Right then
    X := DesktopRect.Right - Width;
  if (Y + Height) > DesktopRect.Bottom then
    Y := DesktopRect.Bottom - Height;
  if X < DesktopRect.Left then
    X := DesktopRect.Left;
  if Y < DesktopRect.Top then
    Y := DesktopRect.Top;

  Top := Y;
  Left := X;

  if Assigned(Owner) and (Owner is TFrmBase) then
    Self.StayOnTop := TFrmBase(Owner).StayOnTop;

  Result := inherited ShowModal;
end;

procedure TFrmBase.UpdateActions;
begin
  actFormMinimize.Visible := FSizeable;
  actFormMaximize.Visible := FSizeable and (WindowState <> wsMaximized);
  actFormRestore.Visible := (WindowState <> wsNormal);
  inherited;
end;

function TFrmBase.GetDesktopRect: TRect;
begin
  if not SystemParametersInfo(SPI_GETWORKAREA, 0, @Result, 0) then
  begin
    Result.Left   := 0;
    Result.Top    := 0;
    Result.Right  := GetSystemMetrics(SM_CXSCREEN);
    Result.Bottom := GetSystemMetrics(SM_CYSCREEN);
  end;
end;

// ő剻ĂĂWԂł̃EBhETCY𓾂
function TFrmBase.GetNormalWindowRect: TRect;
var
  WP: TWindowPlacement;
begin
  WP.length := SizeOf(WP);
  if FShaded and  (WindowState = wsNormal) then
  begin
    GetWindowRect(Self.Handle, Result);
    Result.Bottom := Top + FNormalHeight;
  end else
  if FShaded then
  begin
    GetWindowPlacement(Self.Handle, @WP);
    Result := WP.rcNormalPosition;
    Result.Bottom := Result.Top + FNormalHeight;
  end else
  begin
    GetWindowPlacement(Self.Handle, @WP);
    Result := WP.rcNormalPosition;
  end;
end;

procedure TFrmBase.FormCreate(Sender: TObject);
begin
  FExBorder := True;
  FShaded := False;
  FNormalHeight := Height;
  FWindowFit := True;
  FWindowKind := wkDefault;
  LoadSkinResource;
  ApplySkinResource;
  ApplyConfig;  
  ApplyPrivateConfig;
end;

procedure TFrmBase.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  UpdateConfig;
end;

procedure TFrmBase.FormShow(Sender: TObject);
begin
  UpdateActions;
  if FStayOnTop then
    SetStayOnTop(FStayOnTop);  
end;

procedure TFrmBase.FormDblClick(Sender: TObject);
begin
  if Config.UseWindowShade then
    // EBhEVF[h
    SetShaded(not FShaded)
  else if (not Config.UseWindowShade) and FSizeable then
    // ő剻Eŏ
    if WindowState = wsNormal then
      actFormMaximize.Execute
    else if WindowState = wsMaximized then
      actFormRestore.Execute;
end;

procedure TFrmBase.actFormCloseExecute(Sender: TObject);
begin
  Close;
end;

procedure TFrmBase.actFormMaximizeExecute(Sender: TObject);
begin
  WindowState := wsMaximized;
end;

procedure TFrmBase.actFormRestoreExecute(Sender: TObject);
begin
  WindowState := wsNormal;
end;

procedure TFrmBase.actFormMinimizeExecute(Sender: TObject);
begin
  WindowState := wsMinimized;
end;

procedure TFrmBase.FormPaint(Sender: TObject);
begin
  WindowStyle.Draw(Canvas, ClientRect);
  DrawCaption;
end;

procedure TFrmBase.FormResize(Sender: TObject);
begin
  Invalidate;
  ApplyRegion;
end;

procedure TFrmBase.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  P: TPoint;
begin
  if (Button = mbLeft) and (WindowState = wsNormal) then
  begin
    // EBhËړJn
    ReleaseCapture;
    SendMessage(Handle, WM_SYSCOMMAND, SC_MOVE or 2,0);
  end else
  if Button = mbRight then
  begin
    P := TControl(Sender).ClientToScreen(Point(X, Y));
    PostMessage(Handle, $0313, 0, MakeLParam(P.X, P.Y));
  end;
end;

end.
