unit UFrmAddedNotify;

interface

uses
  Windows, Messages, SysUtils, Controls, Forms, Graphics, Classes,
  ExSpeedButton, UFrmBase, StdCtrls, ExtCtrls, ActnList, ResizeArea, ExPanel,
  ExButton, UStrResource;

type
  TFrmAddedNotify = class(TFrmBase)
    Image: TImage;
    lblPrompt: TLabel;
    Label1: TLabel;
    rbAllow: TRadioButton;
    rbBlock: TRadioButton;
    cbAddMemberList: TCheckBox;
    btnOk: TExButton;
    btnCancel: TExButton;
    procedure rbAllowClick(Sender: TObject);
    procedure rbBlockClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure SetPrompt(Value: String);
  public
    property Prompt: String write SetPrompt;
  end;

implementation

{$R *.dfm}

procedure TFrmAddedNotify.SetPrompt(Value: String);
begin
  lblPrompt.Caption := Value;
end;

procedure TFrmAddedNotify.rbAllowClick(Sender: TObject);
begin
  inherited;
  cbAddMemberList.Checked := True;
end;

procedure TFrmAddedNotify.rbBlockClick(Sender: TObject);
begin
  inherited;
  cbAddMemberList.Checked := False;
end;

procedure TFrmAddedNotify.FormShow(Sender: TObject);
begin
  inherited;
  // 炷
  MessageBeep(MB_ICONASTERISK);
  Caption := RS_APPTITLE;
end;

end.
