unit UConfig;

interface

uses
  Windows, Forms, IniFiles, SysUtils, UNsmUIPluginMainEx, UNsmUtils, ComCtrls;

type
  TCategorizeStyle = (csNone, csGroup, csStatus);
  TSimpleUIConfig = class(TObject)
  public
    // General
    UseTaskTray: Boolean;
    // Theme
    ThemeName: String;
    // Expert
    DoubleBuffered: Boolean;
    // Option
    OptionShowHint: Boolean;
    // MemberList
    Categorize: TCategorizeStyle;
    SortKey: TSortKey;
    HideOffline: Boolean;
    HideEmptyGroup: Boolean;
    HideBlocked: Boolean;
    // Message
    MsgHead: String;
    MsgHead2: String;
    MsgFont: String;    
    // Notify
    NotifyTime: Integer;
    // Path
    PathDefaultBrowser: String;
    Path2chBrowser: String;
    // Window
    UseWindowShade: Boolean;
    SnapToScreenEdge: Boolean;
    SnapToWindowEdge: Boolean;
    SnapSize: Integer;
    MaxTabLength: Integer;
    // MainWindow
    MainLeft: Integer;
    MainTop: Integer;
    MainWidth: Integer;
    MainHeight: Integer;
    MainWinState: TWindowState;
    MainTransparency: Integer;
    MainStayOnTop: Boolean;
    MainTabPosition: TTabPosition;
    // ChatWindow
    ChatLeft: Integer;
    ChatTop: Integer;
    ChatWidth: Integer;
    ChatHeight: Integer;
    ChatWinState: TWindowState;
    ChatTransparency: Integer;
    ChatStayOnTop: Boolean;
    ChatTabPosition: TTabPosition;
    // NotifyWindow
    NotifyTransparency: Integer;

    procedure Initialize;
    procedure LoadFromFile(const FileName: String);
    procedure SaveToFile(const FileName: String);
  end;

var
  Config: TSimpleUIConfig;

implementation

procedure TSimpleUIConfig.Initialize;
begin
  // General
  UseTaskTray := True;
  // Theme
  ThemeName := 'Default';
  // Expert
  DoubleBuffered := True;
  // Option
  OptionShowHint := True;
  // MemberList
  Categorize := csGroup;
  SortKey := skStatus;
  HideOffline := False;
  HideEmptyGroup := False;
  HideBlocked := False;
  // Message
  MsgHead := '<!--NAME--> ̔ :';
  MsgHead2 := '<!--NAME--> ̔ :<BR>'#13#10'<FONT COLOR="#CCCCCC"><!--NOW--></FONT><BR>';
  // Notify
  NotifyTime := 30;
  // Path
  PathDefaultBrowser := '';
  Path2chBrowser := '';
  // Window
  UseWindowShade := False;
  SnapToScreenEdge := True;
  SnapToWindowEdge := True;
  SnapSize := 15;
  MaxTabLength := 20;
  // MainWindow
  MainWidth := 230;
  MainHeight := 350;
  MainLeft := (Screen.Width - MainWidth) div 2;
  MainTop := (Screen.Height - MainHeight) div 2;
  MainWinState := wsNormal;
  MainTransparency := 0;
  MainStayOnTop := False;
  MainTabPosition := tpRight;
  // ChatWindow
  ChatWidth := 400;
  ChatHeight := 400;
  ChatLeft := (Screen.Width - ChatWidth) div 2;
  ChatTop := (Screen.Height - ChatHeight) div 2;
  ChatWinState := wsNormal;
  ChatTransparency := 0;
  ChatStayOnTop := False;
  ChatTabPosition := tpTop;
  // NotifyWindow
  NotifyTransparency := 0;
end;

procedure TSimpleUIConfig.LoadFromFile(const FileName: String);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(FileName);
  try
    UseTaskTray := Ini.ReadBool('General', 'UseTaskTray', UseTaskTray);

    ThemeName := Ini.ReadString('Theme', 'ThemeName', ThemeName);
    DoubleBuffered := Ini.ReadBool('Expert', 'DoubleBuffered', DoubleBuffered);
    OptionShowHint := Ini.ReadBool('Option', 'ShowHint', OptionShowHint);

    Categorize := TCategorizeStyle(Ini.ReadInteger('MemberList', 'Categorize', Ord(Categorize)));
    SortKey := TSortKey(Ini.ReadInteger('MemberList', 'SortKey', Ord(SortKey)));
    HideOffline := Ini.ReadBool('MemberList', 'HideOffline', HideOffline);
    HideEmptyGroup := Ini.ReadBool('MemberList', 'HideEmptyGroup', HideEmptyGroup);
    HideBlocked := Ini.ReadBool('MemberList', 'HideBlocked', HideBlocked);

    MsgHead := DecodeControlChar(Ini.ReadString('Message', 'MsgHead', MsgHead));
    MsgHead2 := DecodeControlChar(Ini.ReadString('Message', 'MsgHead2', MsgHead2));
    MsgFont := Ini.ReadString('Message', 'Font', MsgFont);

    NotifyTime := Ini.ReadInteger('Notify', 'NotifyTime', NotifyTime);

    PathDefaultBrowser := Ini.ReadString('Path', 'DefaultBrowser', PathDefaultBrowser);
    Path2chBrowser := Ini.ReadString('Path', '2chBrowser', Path2chBrowser);

    UseWindowShade := Ini.ReadBool('Window', 'UseWindowShade', UseWindowShade);
    SnapToScreenEdge := Ini.ReadBool('Window', 'SnapToScreenEdge', SnapToScreenEdge);
    SnapToWindowEdge := Ini.ReadBool('Window', 'SnapToWindowEdge', SnapToWindowEdge);
    SnapSize := Ini.ReadInteger('Window', 'SnapSize', SnapSize);
    MaxTabLength := Ini.ReadInteger('Window', 'MaxTabLength', MaxTabLength);

    MainWidth := Ini.ReadInteger('MainWindow', 'Width', MainWidth);
    MainHeight := Ini.ReadInteger('MainWindow', 'Height', MainHeight);
    MainLeft := Ini.ReadInteger('MainWindow', 'Left', MainLeft);
    MainTop := Ini.ReadInteger('MainWindow', 'Top', MainTop);
    MainWinState := TWindowState(Ini.ReadInteger('MainWindow', 'WindowState', Ord(MainWinState)));
    MainTransparency := Ini.ReadInteger('MainWindow', 'Transparency', MainTransparency);
    MainStayOnTop := Ini.ReadBool('MainWindow', 'StayOnTop', MainStayOnTop);
    MainTabPosition := TTabPosition(Ini.ReadInteger('MainWindow', 'TabPosition', Ord(MainTabPosition)));

    ChatWidth := Ini.ReadInteger('ChatWindow', 'Width', ChatWidth);
    ChatHeight := Ini.ReadInteger('ChatWindow', 'Height', ChatHeight);
    ChatLeft := Ini.ReadInteger('ChatWindow', 'Left', ChatLeft);
    ChatTop := Ini.ReadInteger('ChatWindow', 'Top', ChatTop);
    ChatWinState := TWindowState(Ini.ReadInteger('ChatWindow', 'WindowState', Ord(ChatWinState)));
    ChatTransparency := Ini.ReadInteger('ChatWindow', 'Transparency', ChatTransparency);
    ChatStayOnTop := Ini.ReadBool('ChatWindow', 'StayOnTop', ChatStayOnTop);
    ChatTabPosition := TTabPosition(Ini.ReadInteger('ChatWindow', 'TabPosition', Ord(ChatTabPosition)));

    NotifyTransparency := Ini.ReadInteger('NotifyWindow', 'Transparency', NotifyTransparency);
  finally
    Ini.Free;
  end;
end;

procedure TSimpleUIConfig.SaveToFile(const FileName: String);
var
  Ini: TIniFile;
begin
  ForceDirectories(ExtractFilePath(FileName));
  Ini := TIniFile.Create(FileName);
  try
    Ini.WriteBool('General', 'UseTaskTray', UseTaskTray);

    Ini.WriteString('Theme', 'ThemeName', ThemeName);
    Ini.WriteBool('Expert', 'DoubleBuffered', DoubleBuffered);
    Ini.WriteBool('Option', 'ShowHint', OptionShowHint);

    Ini.WriteInteger('MemberList', 'Categorize', Ord(Categorize));
    Ini.WriteInteger('MemberList', 'SortKey', Ord(SortKey));
    Ini.WriteBool('MemberList', 'HideOffline', HideOffline);
    Ini.WriteBool('MemberList', 'HideEmptyGroup', HideEmptyGroup);
    Ini.WriteBool('MemberList', 'HideBlocked', HideBlocked);

    Ini.WriteString('Message', 'MsgHead', EncodeControlChar(MsgHead));
    Ini.WriteString('Message', 'MsgHead2', EncodeControlChar(MsgHead2));
    Ini.WriteString('Message', 'Font', MsgFont);

    Ini.WriteString('Path', 'DefaultBrowser', PathDefaultBrowser);
    Ini.WriteString('Path', '2chBrowser', Path2chBrowser);

    Ini.WriteInteger('Notify', 'NotifyTime', NotifyTime);

    Ini.WriteBool('Window', 'UseWindowShade', UseWindowShade);
    Ini.WriteBool('Window', 'SnapToScreenEdge', SnapToScreenEdge);
    Ini.WriteBool('Window', 'SnapToWindowEdge', SnapToWindowEdge);
    Ini.WriteInteger('Window', 'SnapSize', SnapSize);
    Ini.WriteInteger('Window', 'MaxTabLength', MaxTabLength);

    Ini.WriteInteger('MainWindow', 'Width', MainWidth);
    Ini.WriteInteger('MainWindow', 'Height', MainHeight);
    Ini.WriteInteger('MainWindow', 'Left', MainLeft);
    Ini.WriteInteger('MainWindow', 'Top', MainTop);
    Ini.WriteInteger('MainWindow', 'WindowState', Ord(MainWinState));
    Ini.WriteInteger('MainWindow', 'Transparency', MainTransparency);
    Ini.WriteBool('MainWindow', 'StayOnTop', MainStayOnTop);
    Ini.WriteInteger('MainWindow', 'TabPosition', Ord(MainTabPosition));

    Ini.WriteInteger('ChatWindow', 'Width', ChatWidth);
    Ini.WriteInteger('ChatWindow', 'Height', ChatHeight);
    Ini.WriteInteger('ChatWindow', 'Left', ChatLeft);
    Ini.WriteInteger('ChatWindow', 'Top', ChatTop);
    Ini.WriteInteger('ChatWindow', 'WindowState', Ord(ChatWinState));
    Ini.WriteInteger('ChatWindow', 'Transparency', ChatTransparency);
    Ini.WriteBool('ChatWindow', 'StayOnTop', ChatStayOnTop);
    Ini.WriteInteger('ChatWindow', 'TabPosition', Ord(ChatTabPosition));

    Ini.WriteInteger('NotifyWindow', 'Transparency', NotifyTransparency);
  finally
    Ini.Free;
  end;
end;

initialization
  Config := TSimpleUIConfig.Create;
  Config.Initialize;

finalization
  Config.Free;

end.
 