unit ExButton;
(* g{^ *)

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, StdCtrls, Graphics,
  (* ExUtils, *) USkinStyles;

type
  TButtonState = (bsUp, bsDown, bsHot, bsDisabled);
  TExButton = class(TButton)
  private
    FCanvas:TControlCanvas;
    FUpStyle: TSkinStyle;
    FDownStyle: TSkinStyle;
//    FHotStyle: TSkinStyle;
    FFocused: Boolean;
    procedure SetUpStyle(Value: TSkinStyle);
    procedure SetDownStyle(Value: TSkinStyle);
//    procedure SetHotStyle(Value: TSkinStyle);
    procedure DrawButton(ACanvas: TCanvas; IsDefault, IsDown: Boolean; State: TButtonState);
    procedure ON_CN_DRAWITEM(var Msg: TWMDrawItem); message CN_DRAWITEM;
    procedure ON_WM_LBUTTONDBLCLK(var Msg: TWMLButtonDblClk); message WM_LBUTTONDBLCLK;
    procedure ON_WM_ERASEBKGND(var Msg: TWMEraseBkgnd); message WM_ERASEBKGND;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure SetButtonStyle(ADefault: Boolean);override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property UpStyle: TSkinStyle read FUpStyle write SetUpStyle;
    property DownStyle: TSkinStyle read FDownStyle write SetDownStyle;
//    property HotStyle: TSkinStyle read FHotStyle write SetHotStyle;
  published
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('NSM2', [TExButton]);
end;

constructor TExButton.Create(AOwner: TComponent);
begin
  inherited;
  FUpStyle := TSkinStyle.Create(nil);
  FDownStyle := TSkinStyle.Create(nil);
//  FHotStyle := TSkinStyle.Create(nil, '');

  with FUpStyle do
  begin
    BackgroundColor := clBtnFace;
    BorderWidth := 1;
    BorderStyle := sbOutset;
  end;
  with FDownStyle do
  begin
    BackgroundColor := clBtnFace;
    BorderWidth := 1;
    BorderStyle := sbInset;
  end;
//  FHotStyle.Assign(FUpStyle);

  FCanvas := TControlCanvas.Create;
  TControlCanvas(FCanvas).Control := Self;
  DoubleBuffered := True;
end;

destructor TExButton.Destroy;
begin
  FCanvas.Free;
  FUpStyle.Free;
  FDownStyle.Free;
//  FHotStyle.Free;
  inherited;
end;

procedure TExButton.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.Style := Params.Style or BS_OWNERDRAW;
end;

procedure TExButton.ON_WM_LBUTTONDBLCLK(var Msg: TWMLButtonDblClk);
begin
  Perform(WM_LBUTTONDOWN, Msg.Keys, Longint(Msg.Pos));
end;

procedure TExButton.SetButtonStyle(ADefault: Boolean);
begin
  if ADefault <> FFocused then
  begin
    FFocused := ADefault;
    Refresh;
  end;
end;

procedure TExButton.SetUpStyle(Value: TSkinStyle);
begin
  if Assigned(Value) then
  begin
    FUpStyle.Assign(Value);
    Invalidate;
  end;
end;

procedure TExButton.SetDownStyle(Value: TSkinStyle);
begin
  if Assigned(Value) then
  begin
    FDownStyle.Assign(Value);
    Invalidate;
  end;
end;
{
procedure TExButton.SetHotStyle(Value: TSkinStyle);
begin
  if Assigned(Value) then
  begin
    FHotStyle.Assign(Value);
    Invalidate;
  end;
end;
}

procedure TExButton.ON_WM_ERASEBKGND(var Msg: TWMEraseBkgnd);
begin
  Msg.Result := 1;
end;


procedure TExButton.ON_CN_DRAWITEM(var Msg: TWMDrawItem);
var
  IsDown, IsDefault: Boolean;
  BtnState: TButtonState;
begin
  with Msg.DrawItemStruct^ do
  begin
    FCanvas.Handle := hDC;
    IsDown := itemState and ODS_SELECTED <> 0;
    IsDefault := itemState and ODS_FOCUS <> 0;
  end;
  if not Enabled then BtnState := bsDisabled
  else if IsDown then BtnState := bsDown
  else BtnState := bsUp;

  DrawButton(FCanvas, IsDefault, IsDown, BtnState);
end;

procedure TExButton.DrawButton(ACanvas: TCanvas; IsDefault, IsDown: Boolean; State: TButtonState);
const
  RoundSize = 8;
var
  R: TRect;
begin
  ACanvas.Font := Self.Font;
  if IsDown then
  begin
    R := ClientRect;
    FDownStyle.Draw(ACanvas, R);
    FDownStyle.AssignToFont(ACanvas.Font);
  end
  else
  begin
    R := ClientRect;
    FUpStyle.Draw(ACanvas, R);
    FUpStyle.AssignToFont(ACanvas.Font);
  end;

  R := ClientRect;
  if FFocused and IsDefault then
  begin
    InflateRect(R, -4, -4);
    ACanvas.Pen.Color := clWindowFrame;
    ACanvas.Brush.Style := bsClear;
    ACanvas.Brush.Color := Color;
    DrawFocusRect(FCanvas.Handle, R);
  end;

  R := ClientRect;
  if IsDown then
    OffsetRect(R, 1, 1);

  with ACanvas do
  begin
    Brush.Style := bsClear;
    if State = bsDisabled then
    begin
      OffsetRect(R, 1, 1);
      Font.Color := clBtnHighlight;
      DrawText(Handle, PChar(Caption), Length(Caption), R, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
      OffsetRect(R, -1, -1);
      Font.Color := clBtnShadow;
      DrawText(Handle, PChar(Caption), Length(Caption), R, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
    end else
      DrawText(Handle, PChar(Caption), Length(Caption), R,
        DT_CENTER or DT_VCENTER or DT_SINGLELINE);
  end;

  FCanvas.Handle := 0;
end;

end.
