<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/* -- Define -- */
define('RA_SYSTEM_DIR', 'system'. DIRECTORY_SEPARATOR);

define('RA_APP_DIR', 'application'. DIRECTORY_SEPARATOR);
define('RA_CONFIG_DIR', RA_APP_DIR. 'config'. DIRECTORY_SEPARATOR);
define('RA_CTRL_DIR', RA_APP_DIR. 'controllers'. DIRECTORY_SEPARATOR);
define('RA_HELPER_DIR', RA_APP_DIR. 'helpers'. DIRECTORY_SEPARATOR);
define('RA_LIBS_DIR', RA_APP_DIR. 'libs'. DIRECTORY_SEPARATOR);
define('RA_MODEL_DIR', RA_APP_DIR. 'models'. DIRECTORY_SEPARATOR);
define('RA_VIEW_DIR', RA_APP_DIR. 'views'. DIRECTORY_SEPARATOR);
define('RA_TMP_DIR', RA_APP_DIR. 'tmp'. DIRECTORY_SEPARATOR);
define('RA_LOG_DIR', RA_TMP_DIR. 'logs'. DIRECTORY_SEPARATOR);

define('RA_SQL_DIR', RA_CORE_DIR. RA_MODEL_DIR. 'sql'. DIRECTORY_SEPARATOR);
define('RA_CREATE_SQL_DIR', RA_SQL_DIR. 'create'. DIRECTORY_SEPARATOR);
define('RA_CREATE_SQL_OLDDIR', RA_SQL_DIR. 'create'. DIRECTORY_SEPARATOR. 'old'. DIRECTORY_SEPARATOR);
define('RA_CREATE_SQL_55DIR', RA_SQL_DIR. 'create'. DIRECTORY_SEPARATOR. '5.5'. DIRECTORY_SEPARATOR);
define('RA_LOAD_SQL_DIR', RA_SQL_DIR. 'load'. DIRECTORY_SEPARATOR);
/* ------------------------------------------------------------------------ */
/* -- Include -- */
require RA_CORE_DIR. RA_SYSTEM_DIR. 'Ra.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaConfig.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaController.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaModel.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaView.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaHelper.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaException.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaRequest.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaSession.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaResult.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaMessage.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaUtil.php';
require RA_CORE_DIR. RA_SYSTEM_DIR. 'RaLog.php';
$libs = glob(RA_CORE_DIR. RA_LIBS_DIR. '*.php');
if (is_array($libs)) foreach($libs as $libFile) require $libFile;
$models = glob(RA_CORE_DIR. RA_MODEL_DIR. '*.php');
if (is_array($models)) foreach($models as $modelFile) require $modelFile;
$configs = glob(RA_CORE_DIR. RA_CONFIG_DIR. '*.php');
if (is_array($configs)) foreach($configs as $configFile) require $configFile;
/* ------------------------------------------------------------------------ */
?>
