<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class SystemUtil {

  private static $_singleton = null;
  private $_messages = array();

  public static function getSystemDataSize($createYyyyMm) {
    $systemDataSize = 0;
    $next = 0;
    $month = 1;
    while(true) {
      try {
        $yyyymm = Calendar::getNextMonth($next);
        if ($yyyymm < $createYyyyMm) break;
        $log = new Log(true, $yyyymm);
        $systemDataSize = $systemDataSize + $log->getDataSize();
        $log = null;
        $next--;
        $month++;
      } catch (Exception $exception) {
        if ($exception->getCode() == RaModel::TABLE_NOTFOUND_ERR_CODE) {
          $next--;
          $month++;
          continue;
        } else {
          throw $exception;
        }
      }
    }
    $alias = new Alias();
    $systemDataSize = $systemDataSize + $alias->getDataSize();
    $domain = new Domain();
    $systemDataSize = $systemDataSize + $domain->getDataSize();
    $site = new Site();
    $systemDataSize = $systemDataSize + $site->getDataSize();
    $title = new Title();
    $systemDataSize = $systemDataSize + $title->getDataSize();
    $system = new System();
    $systemDataSize = $systemDataSize + $system->getDataSize();
    $logs = glob(RA_CORE_DIR. RA_LOG_DIR. constant(RaConfig::DATABASE_DEFINE_TABLE_PREFIX). '*');
    if (is_array($logs))  foreach($logs as $logFile) $systemDataSize +=  filesize($logFile);

    return $systemDataSize;
  }

  public static function checkPhpMemoryLimit(){
    $memoryLimit = self::_getMemoryLimit();
    return ($memoryLimit >= Config::MINIMUM_MEMORY_LIMIT || $memoryLimit == -1) ? true : false; 
  }

  public static function versionCompareRa($version1, $version2, $operator) {
    return version_compare($version1, $version2, $operator);
  }

  public static function setSystemMessage($message){
    $messages = SystemUtil::_getInstance()->_messages;
    array_push($messages, $message);
    SystemUtil::_getInstance()->_messages = $messages;
  }

  public static function getSystemMessage(){
    return SystemUtil::_getInstance()->_messages;
  }

  public static function clearSystemMessage(){
    SystemUtil::_getInstance()->_messages = array();
  }

  public static function isInstalled($fileOnly=false) {
    try {
      if (!$fileOnly) {
        if (!file_exists(SETTING_DATABASE_FILE)) return false;
        if (!RaModel::isDatabaseDefined()) 
          throw new RaException(RaConfig::DATABASE_CONFIG_UNDEFINED_ERR_MSG, RaConfig::DATABASE_CONFIG_UNDEFINED_ERR_CODE);
        $system = new System();
      }      
      if (!file_exists(SETTING_INSTALL_COMPLETE_FILE)) return false;
    } catch (Exception $exception) {
      File::deleteFile(SETTING_DATABASE_FILE);
      return false;
    }
    return true;
  }

  private function __construct() {
  }

  private static function _getInstance() {
    if (SystemUtil::$_singleton == null) {
      SystemUtil::$_singleton = new SystemUtil();
    }
    return SystemUtil::$_singleton;
  }

  private static function _getMemoryLimit(){
    $memoryLimit = str_replace('M', '', ini_get('memory_limit'));
    return trim($memoryLimit) <> '' ? $memoryLimit : -1;
  }

}
?>
