/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.ui.notify.cache;

import bl.radio.ui.notify.cache.OneFont;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontCache {
    private static List<OneFont> _existing = new ArrayList<OneFont>();

    public static void disposeAll() {
        for (OneFont oneFont : _existing) {
            if (oneFont.getFont() == null || oneFont.getFont().isDisposed()) continue;
            oneFont.getFont().dispose();
        }
        _existing.clear();
    }

    public static Font getFont(FontData fontData) {
        try {
            boolean bl = false;
            OneFont oneFont = null;
            for (OneFont oneFont2 : _existing) {
                if (!oneFont2.matches(fontData)) continue;
                if (oneFont2.getFont().isDisposed()) {
                    bl = true;
                    oneFont = oneFont2;
                    break;
                }
                return oneFont2.getFont();
            }
            if (bl) {
                _existing.remove(oneFont);
            }
            OneFont oneFont3 = new OneFont(fontData);
            _existing.add(oneFont3);
            return oneFont3.getFont();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static int getCount() {
        return _existing.size();
    }

    public static Font getFont(Font font) {
        try {
            if (font == null || font.isDisposed()) {
                return null;
            }
            FontData fontData = font.getFontData()[0];
            return FontCache.getFont(fontData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Font getFont(String string, int n, int n2) {
        try {
            boolean bl = false;
            OneFont oneFont = null;
            for (OneFont oneFont2 : _existing) {
                if (!oneFont2.getName().equals(string) || oneFont2.getHeight() != n || oneFont2.getStyle() != n2) continue;
                if (oneFont2.getFont().isDisposed()) {
                    bl = true;
                    oneFont = oneFont2;
                    break;
                }
                return oneFont2.getFont();
            }
            if (bl) {
                _existing.remove(oneFont);
            }
            OneFont oneFont3 = new OneFont(string, n, n2);
            _existing.add(oneFont3);
            return oneFont3.getFont();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

