/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.task;

import bl.radio.ConfigBox;
import bl.radio.StatusBox;
import bl.radio.config.StationModel;
import bl.radio.pls.PlsModel;
import bl.radio.pls.StationCrowler;
import bl.radio.task.UpdateEvent;
import bl.radio.task.UpdateListener;
import bl.radio.util.WebClientUtil;
import ch.qos.logback.classic.Logger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.LoggerFactory;

public class ChannelUpdateTask
implements Runnable {
    private static Logger logger = (Logger)LoggerFactory.getLogger(ChannelUpdateTask.class);
    private static final long IDLE_TIME = TimeUnit.MINUTES.toMillis(3L);
    private static final long PERIOD_TIME = TimeUnit.DAYS.toMillis(2L);
    private File db;
    private UpdateListener listener;
    private boolean isStop;
    private File lasted;

    public ChannelUpdateTask(File file, UpdateListener updateListener) {
        this.db = file;
        this.listener = updateListener;
        this.lasted = new File(this.db, "lastupdate.lst");
    }

    @Override
    public void run() {
        this.isStop = false;
        while (true) {
            try {
                Thread.sleep(IDLE_TIME);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isWork()) continue;
            try {
                this.createDb();
                continue;
            }
            catch (Exception exception) {
                logger.error("Update DB Error!!", (Throwable)exception);
                continue;
            }
            break;
        }
    }

    private boolean isWork() {
        StatusBox statusBox = StatusBox.getInstance();
        long l = statusBox.getLastedOperation();
        long l2 = System.currentTimeMillis();
        return l2 - l > IDLE_TIME;
    }

    public void createDb() throws Exception {
        ConfigBox configBox = ConfigBox.getInstance();
        Map<String, String> map = this.getLastUpdates(this.lasted);
        for (StationModel stationModel : configBox.getStationModels()) {
            if (this.isStop || !this.isWork()) break;
            StationCrowler stationCrowler = new StationCrowler();
            List<PlsModel> list = stationCrowler.crowl(stationModel.getUrl(), stationModel.getClowler());
            int n = 0;
            n = stationModel.isDirectDb() ? this.createDirectDB(list, stationModel, map) : this.createPlsFromDB(list, stationModel, map);
            if (!this.isWork()) break;
            this.deleteOldChannels(list, stationModel);
            if (n <= 0) continue;
            this.listener.notifyUpdateDb(new UpdateEvent(stationModel.getName(), 0));
        }
        System.gc();
        this.listener.notifyUpdateDb(new UpdateEvent("", 9));
    }

    private Map<String, String> getLastUpdates(File file) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split("\t");
                    hashMap.put(stringArray[0], stringArray[1]);
                }
            }
        }
        return hashMap;
    }

    private void saveLastUpdate(Map<String, String> map, File file) throws Exception {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
             PrintWriter printWriter = new PrintWriter(outputStreamWriter);){
            for (String string : map.keySet()) {
                printWriter.println(string + "\t" + map.get(string));
            }
        }
    }

    private int createDirectDB(List<PlsModel> list, StationModel stationModel, Map<String, String> map) throws Exception {
        int n = 0;
        File file = new File(this.db, stationModel.getName());
        if (!file.exists()) {
            file.mkdirs();
        }
        for (PlsModel plsModel : list) {
            if (this.isStop) break;
            String string = stationModel.getName() + ":" + plsModel.getKey();
            if (map.containsKey(string)) {
                long l = new Long(map.get(string));
                long l2 = System.currentTimeMillis();
                if (l2 - l < PERIOD_TIME) continue;
            }
            File file2 = new File(file, plsModel.getKey() + ".db");
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                 OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
                 PrintWriter printWriter = new PrintWriter(outputStreamWriter);){
                printWriter.println(plsModel.getName());
                printWriter.println(plsModel.getDescription());
                printWriter.println(plsModel.getGenre());
                printWriter.println(plsModel.getPlaylist());
            }
            map.put(string, System.currentTimeMillis() + "");
            this.saveLastUpdate(map, this.lasted);
            logger.debug("createdb..." + stationModel.getName() + ":" + plsModel.getName());
            ++n;
        }
        return n;
    }

    private int createPlsFromDB(List<PlsModel> list, StationModel stationModel, Map<String, String> map) throws Exception {
        int n = 0;
        File file = new File(this.db, "temp");
        if (!file.exists()) {
            file.mkdirs();
        }
        FileUtils.cleanDirectory((File)file);
        for (PlsModel plsModel : list) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            HttpEntity httpEntity;
            Object object9;
            Object object10;
            String string;
            if (this.isStop || !this.isWork()) break;
            String string2 = stationModel.getName() + ":" + plsModel.getKey();
            if (map.containsKey(string2)) {
                long l = new Long(map.get(string2));
                long l2 = System.currentTimeMillis();
                if (l2 - l < PERIOD_TIME) continue;
            }
            if ((string = plsModel.getPlaylist()) == null || string.isEmpty()) continue;
            try {
                object10 = new HttpGet(plsModel.getPlaylist());
                object9 = WebClientUtil.getResponse((HttpUriRequest)object10);
                httpEntity = object9.getEntity();
            }
            catch (Exception exception) {
                logger.warn("Http Response Error...", (Throwable)exception);
                continue;
            }
            object10 = new File(file, plsModel.getKey() + ".pls");
            object9 = httpEntity.getContent();
            Object object11 = null;
            try {
                object8 = new InputStreamReader((InputStream)object9, "UTF-8");
                object7 = null;
                try {
                    object6 = new BufferedReader((Reader)object8);
                    object5 = null;
                    try {
                        object4 = new BufferedOutputStream(new FileOutputStream((File)object10));
                        object3 = null;
                        try {
                            object2 = new OutputStreamWriter((OutputStream)object4, "UTF-8");
                            object = null;
                            try {
                                int n2;
                                while ((n2 = ((BufferedReader)object6).read()) != -1) {
                                    ((OutputStreamWriter)object2).write(n2);
                                }
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (object2 != null) {
                                    if (object != null) {
                                        try {
                                            ((OutputStreamWriter)object2).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        ((OutputStreamWriter)object2).close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            object3 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object4 != null) {
                                if (object3 != null) {
                                    try {
                                        ((FilterOutputStream)object4).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object3).addSuppressed(throwable);
                                    }
                                } else {
                                    ((FilterOutputStream)object4).close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        object5 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object6 != null) {
                            if (object5 != null) {
                                try {
                                    ((BufferedReader)object6).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object5).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedReader)object6).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object7 = throwable;
                    throw throwable;
                }
                finally {
                    if (object8 != null) {
                        if (object7 != null) {
                            try {
                                ((InputStreamReader)object8).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object7).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStreamReader)object8).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object11 = throwable;
                throw throwable;
            }
            finally {
                if (object9 != null) {
                    if (object11 != null) {
                        try {
                            ((InputStream)object9).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object11).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object9).close();
                    }
                }
            }
            logger.debug("downloading..." + stationModel.getName() + ":" + plsModel.getName());
            object9 = new File(file, plsModel.getKey() + ".db");
            object11 = new FileInputStream((File)object10);
            object8 = null;
            try {
                object7 = new InputStreamReader((InputStream)object11, "UTF-8");
                object6 = null;
                try {
                    object5 = new BufferedReader((Reader)object7);
                    object4 = null;
                    try {
                        object3 = new BufferedOutputStream(new FileOutputStream((File)object9));
                        object2 = null;
                        try {
                            object = new OutputStreamWriter((OutputStream)object3, "UTF-8");
                            Throwable throwable = null;
                            try (PrintWriter printWriter = new PrintWriter((Writer)object);){
                                Object object12;
                                Object object13;
                                String string3 = null;
                                ArrayList<String> arrayList = new ArrayList<String>();
                                while ((string3 = ((BufferedReader)object5).readLine()) != null) {
                                    if (string3.trim().length() == 0 || !string3.toLowerCase().startsWith("file")) continue;
                                    object13 = new StringTokenizer(string3, "=");
                                    ((StringTokenizer)object13).nextToken();
                                    object12 = ((StringTokenizer)object13).nextToken().trim();
                                    if (WebClientUtil.isIpUrl((String)object12)) continue;
                                    arrayList.add((String)object12);
                                }
                                object13 = WebClientUtil.sortUrl(arrayList);
                                printWriter.println(plsModel.getName());
                                printWriter.println(plsModel.getDescription());
                                printWriter.println(plsModel.getGenre());
                                object12 = object13.iterator();
                                while (object12.hasNext()) {
                                    String string4 = (String)object12.next();
                                    printWriter.println(string4);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (object != null) {
                                    if (throwable != null) {
                                        try {
                                            ((OutputStreamWriter)object).close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        ((OutputStreamWriter)object).close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object3 != null) {
                                if (object2 != null) {
                                    try {
                                        ((FilterOutputStream)object3).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object2).addSuppressed(throwable);
                                    }
                                } else {
                                    ((FilterOutputStream)object3).close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        object4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object5 != null) {
                            if (object4 != null) {
                                try {
                                    ((BufferedReader)object5).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object4).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedReader)object5).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    object6 = throwable;
                    throw throwable;
                }
                finally {
                    if (object7 != null) {
                        if (object6 != null) {
                            try {
                                ((InputStreamReader)object7).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object6).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStreamReader)object7).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object8 = throwable;
                throw throwable;
            }
            finally {
                if (object11 != null) {
                    if (object8 != null) {
                        try {
                            ((FileInputStream)object11).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object8).addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)object11).close();
                    }
                }
            }
            ((File)object10).delete();
            object11 = new File(new File(this.db, stationModel.getName()), plsModel.getKey() + ".db");
            if (((File)object11).exists()) {
                ((File)object11).delete();
            }
            FileUtils.moveFile((File)object9, (File)object11);
            map.put(string2, System.currentTimeMillis() + "");
            this.saveLastUpdate(map, this.lasted);
            logger.debug("createdb..." + stationModel.getName() + ":" + plsModel.getName());
            ++n;
        }
        return n;
    }

    private void deleteOldChannels(List<PlsModel> list, StationModel stationModel) {
        File file = new File(this.db, stationModel.getName());
        for (File file2 : file.listFiles()) {
            boolean bl = false;
            for (PlsModel plsModel : list) {
                String string = file2.getName().replace(".db", "");
                if (!string.equals(plsModel.getKey())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            try {
                file2.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isStop() {
        return this.isStop;
    }

    public void setStop(boolean bl) {
        this.isStop = bl;
    }
}

