/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.util;

import ch.qos.logback.classic.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.LoggerFactory;

public class TargetLineFactory {
    private static Logger logger = (Logger)LoggerFactory.getLogger(TargetLineFactory.class);
    private static TargetLineFactory targetLineFactory;
    private static final float SAMPLE_RATE = 16000.0f;
    private static final int SAMPLE_SIZE_IN_BIT = 16;
    private static final int CHANNELS = 1;
    public static final int BUFFER_SIZE = 256;
    private TargetDataLine line;
    private AudioFormat format;

    private TargetLineFactory() {
        try {
            this.format = new AudioFormat(16000.0f, 16, 1, true, true);
            this.line = AudioSystem.getTargetDataLine(this.format);
        }
        catch (LineUnavailableException lineUnavailableException) {
            logger.error("", (Throwable)lineUnavailableException);
        }
    }

    public static TargetLineFactory getInstance() {
        if (targetLineFactory == null) {
            targetLineFactory = new TargetLineFactory();
        }
        return targetLineFactory;
    }

    public TargetDataLine getOpenTargetDataLine() throws LineUnavailableException {
        if (this.line.isOpen()) {
            this.line.drain();
            this.line.stop();
            this.line.close();
        }
        this.line.open(this.format, 256);
        return this.line;
    }

    public void release() {
        if (this.line.isOpen()) {
            this.line.drain();
            this.line.stop();
            this.line.close();
        }
    }
}

