/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.ui.notify.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    private static HashMap<String, Image> _ImageMap = new HashMap();
    private static final String ICON_ROOT_PATH = "/icon/";

    public static Image getImage(String string) {
        string = ICON_ROOT_PATH + string;
        Image image = _ImageMap.get(string);
        if (image == null) {
            image = ImageCache.createImage(string);
            _ImageMap.put(string, image);
        }
        return image;
    }

    private static Image createImage(String string) {
        ClassLoader classLoader = ImageCache.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null && (inputStream = classLoader.getResourceAsStream(string.substring(1))) == null && (inputStream = classLoader.getResourceAsStream(string)) == null && (inputStream = classLoader.getResourceAsStream(string.substring(1))) == null) {
            return null;
        }
        Image image = new Image((Device)Display.getDefault(), inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    public static void dispose() {
        Iterator<Image> iterator = _ImageMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
    }
}

