/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.task;

import bl.radio.ConfigBox;
import bl.radio.DjPlayer;
import bl.radio.RadioKaras;
import bl.radio.StatusBox;
import bl.radio.engine.PlayerStreamer;
import bl.radio.util.TwitterHelper;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.TimerTask;
import org.eclipse.swt.widgets.Display;
import org.slf4j.LoggerFactory;
import uk.co.caprica.vlcj.player.headless.HeadlessMediaPlayer;

public class ShutDownTask
extends TimerTask {
    private static Logger logger = (Logger)LoggerFactory.getLogger(ShutDownTask.class);
    private RadioKaras rk;

    public ShutDownTask(RadioKaras radioKaras) {
        this.rk = radioKaras;
    }

    @Override
    public void run() {
        logger.debug("Shut down timer function. Now!");
        StatusBox statusBox = StatusBox.getInstance();
        statusBox.resetLastedOperation();
        try {
            TwitterHelper.sleepingUpdateTwitter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HeadlessMediaPlayer headlessMediaPlayer;
                DjPlayer djPlayer;
                ConfigBox configBox = null;
                try {
                    configBox = ConfigBox.getInstance();
                    configBox.saveConfig();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PlayerStreamer playerStreamer = ShutDownTask.this.rk.getPlayer();
                if (playerStreamer != null) {
                    ShutDownTask.this.feadOut(playerStreamer);
                } else {
                    djPlayer = ShutDownTask.this.rk.getDjPlayer();
                    if (djPlayer != null && (headlessMediaPlayer = djPlayer.getPlayerStreamers()) != null) {
                        for (Serializable serializable : headlessMediaPlayer) {
                            ShutDownTask.this.feadOut((PlayerStreamer)serializable);
                        }
                    }
                }
                try {
                    Serializable serializable;
                    djPlayer = configBox.getMediaPlayerFactory();
                    headlessMediaPlayer = djPlayer.newHeadlessMediaPlayer();
                    int n = 0;
                    headlessMediaPlayer.setVolume(n);
                    serializable = new File(configBox.getApplicationPath(), "sleep.mp3");
                    headlessMediaPlayer.playMedia(((File)serializable).getPath(), new String[0]);
                    for (int i = 0; i < 50 && (n += 5) <= 80; ++i) {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        headlessMediaPlayer.setVolume(n);
                    }
                    while (headlessMediaPlayer.isPlaying()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    headlessMediaPlayer.release();
                    djPlayer.release();
                }
                catch (Exception exception) {
                    logger.warn("Sleep Timer Error!!", (Throwable)exception);
                }
                finally {
                    System.exit(0);
                }
            }
        });
    }

    private void feadOut(PlayerStreamer playerStreamer) {
        int n = playerStreamer.getVolume();
        for (int i = 0; i < 50 && (n -= 5) > 10; ++i) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (playerStreamer == null || !playerStreamer.isPlay()) continue;
            playerStreamer.setVolume(n);
        }
        if (playerStreamer != null) {
            playerStreamer.stop();
        }
    }
}

