/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.channel;

import bl.radio.channel.ChannelFactory;
import bl.radio.channel.ChannelModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CannelEditor {
    private String dbPath;

    public CannelEditor(String string) {
        this.dbPath = string;
    }

    public List<ChannelModel> getList() throws Exception {
        return ChannelFactory.getChannels(this.dbPath, "Appendeix", "appendix");
    }

    public boolean create(ChannelModel channelModel) throws Exception {
        File file = this.getNewRawFile(channelModel);
        if (file.exists()) {
            return false;
        }
        this.store(file, channelModel);
        return true;
    }

    public boolean update(ChannelModel channelModel) throws Exception {
        File file = this.getRawFile(channelModel);
        if (file.exists()) {
            file.delete();
        }
        this.store(file, channelModel);
        return true;
    }

    public void delete(ChannelModel channelModel) {
        File file = this.getRawFile(channelModel);
        if (file.exists()) {
            file.delete();
        }
    }

    private void store(File file, ChannelModel channelModel) throws Exception {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
             PrintWriter printWriter = new PrintWriter(outputStreamWriter);){
            printWriter.println(channelModel.getStation());
            printWriter.println(channelModel.getDescription());
            printWriter.println(channelModel.getCategory());
            for (String string : channelModel.getUrls()) {
                printWriter.println(string);
            }
        }
    }

    private File getRawFile(ChannelModel channelModel) {
        File file = new File(this.dbPath, "appendix");
        return new File(file, channelModel.getRawName());
    }

    private File getNewRawFile(ChannelModel channelModel) {
        Date date = new Date();
        String string = date.getTime() + "";
        File file = new File(this.dbPath, "appendix");
        return new File(file, StringUtils.leftPad((String)string, (int)20, (char)'0') + ".db");
    }
}

