/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.player.EqualizerListener;

public final class Equalizer {
    private final int bandCount;
    private final List<EqualizerListener> listeners = new ArrayList<EqualizerListener>();
    private float preamp;
    private final float[] bandAmps;

    Equalizer(LibVlc libvlc) {
        this.bandCount = libvlc.libvlc_audio_equalizer_get_band_count();
        this.bandAmps = new float[this.bandCount];
    }

    public final void addEqualizerListener(EqualizerListener listener) {
        this.listeners.add(listener);
    }

    public final void removeEqualizerListener(EqualizerListener listener) {
        this.listeners.remove(listener);
    }

    public final int getBandCount() {
        return this.bandCount;
    }

    public final float getPreamp() {
        return this.preamp;
    }

    public final void setPreamp(float newPreamp) {
        this.checkAmp(newPreamp);
        this.preamp = newPreamp;
        this.fireEqualizerChanged();
    }

    public final float getAmp(int index) {
        if (index >= 0 && index < this.bandCount) {
            return this.bandAmps[index];
        }
        throw new IllegalArgumentException("Invalid band index");
    }

    public final void setAmp(int index, float newAmp) {
        this.checkAmp(newAmp);
        if (index < 0 || index >= this.bandCount) {
            throw new IllegalArgumentException("Invalid band index");
        }
        this.bandAmps[index] = newAmp;
        this.fireEqualizerChanged();
    }

    public final float[] getAmps() {
        float[] result = new float[this.bandCount];
        this.copy(this.bandAmps, result);
        return result;
    }

    public final void setAmps(float[] newAmps) {
        if (newAmps != null && newAmps.length == this.bandCount) {
            for (float newAmp : newAmps) {
                this.checkAmp(newAmp);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.copy(newAmps, this.bandAmps);
        this.fireEqualizerChanged();
    }

    public final void setEqualizer(Equalizer equalizer) {
        if (equalizer == null) {
            throw new IllegalArgumentException();
        }
        this.preamp = equalizer.preamp;
        this.copy(equalizer.bandAmps, this.bandAmps);
        this.fireEqualizerChanged();
    }

    public final void reset() {
        this.preamp = 0.0f;
        for (int i = 0; i < this.bandCount; ++i) {
            this.bandAmps[i] = 0.0f;
        }
        this.fireEqualizerChanged();
    }

    private void checkAmp(float amp) {
        if (amp < -20.0f || amp > 20.0f) {
            throw new IllegalArgumentException("Invalid amplification value: " + amp);
        }
    }

    private void copy(float[] from, float[] to) {
        System.arraycopy(from, 0, to, 0, this.bandCount);
    }

    private void fireEqualizerChanged() {
        for (EqualizerListener listener : this.listeners) {
            listener.equalizerChanged(this);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("preamp=").append(this.preamp).append(',');
        sb.append("bandAmps=").append(Arrays.toString(this.bandAmps)).append(']');
        return sb.toString();
    }
}

