/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.XmlSerializer;

public class CompactXmlSerializer
extends XmlSerializer {
    public CompactXmlSerializer(CleanerProperties props) {
        super(props);
    }

    protected void serialize(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, false);
        List tagChildren = tagNode.getAllChildren();
        if (!this.isMinimizedTagSyntax(tagNode)) {
            ListIterator childrenIt = tagChildren.listIterator();
            while (childrenIt.hasNext()) {
                String content;
                Object item = childrenIt.next();
                if (item == null) continue;
                if (item instanceof ContentNode) {
                    content = ((ContentNode)item).getContent().trim();
                    writer.write(this.dontEscape(tagNode) ? content.replaceAll("]]>", "]]&gt;") : this.escapeXml(content));
                    if (!childrenIt.hasNext()) continue;
                    if (!Utils.isWhitespaceString(childrenIt.next())) {
                        writer.write("\n");
                    }
                    childrenIt.previous();
                    continue;
                }
                if (item instanceof CommentNode) {
                    content = ((CommentNode)item).getCommentedContent().trim();
                    writer.write(content);
                    continue;
                }
                ((BaseToken)item).serialize(this, writer);
            }
            this.serializeEndTag(tagNode, writer, false);
        }
    }
}

